/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.item.custom;

import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.block.custom.BluestoneOreBlock;
import net.turtleboi.bytebuddies.entity.ModEntities;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.entity.entities.HologramBuddyEntity;
import net.turtleboi.bytebuddies.util.AttributeModifierUtil;
import net.turtleboi.bytebuddies.util.InventoryUtil;

public class FloppyDiskItem
extends Item {
    private final FloppyTier tier;
    private final String colorKey;

    public FloppyDiskItem(Item.Properties properties, String tier, String colorKey) {
        super(properties.rarity(FloppyTier.fromName(tier).getRarity()));
        this.tier = FloppyTier.fromName(tier);
        this.colorKey = colorKey;
    }

    public String getTierKey() {
        return this.tier.name().toLowerCase(Locale.ROOT);
    }

    public String colorKey() {
        return this.colorKey;
    }

    public FloppyTier getTier() {
        return this.tier;
    }

    public void appendHoverText(ItemStack floppyStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        TextColor tierColor = TierColors.forTier(this.getTierKey());
        MutableComponent tierName = Component.translatable((String)("tooltip.bytebuddies.floppy_tier." + this.getTierKey())).withStyle(Style.EMPTY.withColor(tierColor));
        tooltip.add((Component)Component.translatable((String)"tooltip.bytebuddies.floppy.tier_line", (Object[])new Object[]{tierName}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)("tooltip.bytebuddies.floppy.desc." + this.colorKey)).withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.translatable((String)""));
        FloppyTier tier = FloppyTier.fromName(this.getTierKey());
        FloppyDiskItem.addWhenInstalled(tooltip, tier, this.colorKey);
    }

    private static void addWhenInstalled(List<Component> tooltip, FloppyTier tier, String colorKey) {
        tooltip.add((Component)Component.literal((String)"When installed:").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        switch (colorKey) {
            case "blue": {
                float multiplier = switch (tier.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 1.2f;
                    case 1 -> 1.35f;
                    case 2 -> 1.5f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percentFromMultiplier(multiplier) + " task radius"));
                break;
            }
            case "green": {
                float multiplier = switch (tier.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 0.9f;
                    case 1 -> 0.8f;
                    case 2 -> 0.7f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percentFromMultiplier(1.0f / multiplier) + " efficiency (lower energy cost)"));
                tooltip.add(FloppyDiskItem.malusLine(FloppyDiskItem.percentFromMultiplier(multiplier) + " energy cost"));
                break;
            }
            case "red": {
                float speedMultiplier = switch (tier.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 1.2f;
                    case 1 -> 1.35f;
                    case 2 -> 1.5f;
                };
                float energyMultiplier = switch (tier.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 1.3f;
                    case 1 -> 1.5f;
                    case 2 -> 1.7f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percentFromMultiplier(speedMultiplier) + " action speed"));
                tooltip.add(FloppyDiskItem.malusLine(FloppyDiskItem.percentFromMultiplier(energyMultiplier) + " efficiency (higher energy cost)"));
                break;
            }
            case "black": {
                float wearMultiplier = switch (tier.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 0.85f;
                    case 1 -> 0.7f;
                    case 2 -> 0.55f;
                };
                float healthPercentage = switch (tier.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 1.0f;
                    case 1 -> 1.5f;
                    case 2 -> 2.0f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percentFromMultiplier(1.0f / wearMultiplier) + " tool longevity (reduced wear)"));
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percent(healthPercentage) + " Max Health"));
                break;
            }
            case "purple": {
                float add = switch (tier.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 0.33f;
                    case 1 -> 0.425f;
                    case 2 -> 0.5f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percent(add) + " extra primary yield chance"));
                tooltip.add((Component)Component.literal((String)"Can exceed 100% for multiple extra rolls.").withStyle(ChatFormatting.DARK_GRAY));
                break;
            }
            case "yellow": {
                float add = switch (tier.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 0.5f;
                    case 1 -> 0.625f;
                    case 2 -> 0.85f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", FloppyDiskItem.percent(add) + " byproduct roll chance"));
                tooltip.add((Component)Component.literal((String)"Can exceed 100% for multiple byproduct rolls.").withStyle(ChatFormatting.DARK_GRAY));
                break;
            }
            case "pink": {
                float power = switch (tier.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 0.2f;
                    case 1 -> 0.35f;
                    case 2 -> 0.5f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", "Aura power " + FloppyDiskItem.percent(power)));
                break;
            }
            case "cyan": {
                float chance = switch (tier.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 0.125f;
                    case 1 -> 0.175f;
                    case 2 -> 0.25f;
                };
                tooltip.add(FloppyDiskItem.bonusLine("+", "Spawn chance " + FloppyDiskItem.percent(chance) + " on success"));
                break;
            }
            default: {
                tooltip.add((Component)Component.literal((String)"No effects").withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    private static Component bonusLine(String sign, String text) {
        return Component.literal((String)(sign + " " + text)).withStyle(ChatFormatting.BLUE);
    }

    private static Component malusLine(String text) {
        return Component.literal((String)("\u2212 " + text)).withStyle(ChatFormatting.RED);
    }

    private static String percentFromMultiplier(float multiplier) {
        float percentage = (multiplier - 1.0f) * 100.0f;
        if (percentage < 0.0f) {
            percentage = -percentage;
        }
        return FloppyDiskItem.trimPercent(percentage);
    }

    private static String percent(float value) {
        float percentage = value * 100.0f;
        return FloppyDiskItem.trimPercent(percentage);
    }

    private static String trimPercent(float pct) {
        float abs = Math.abs(pct);
        if (Math.abs(pct - (float)Math.round(pct)) < 0.05f) {
            return Math.round(pct) + "%";
        }
        if (abs < 10.0f) {
            return String.format(Locale.ROOT, "%.2f%%", Float.valueOf(pct));
        }
        return String.format(Locale.ROOT, "%.1f%%", Float.valueOf(pct));
    }

    public static enum FloppyTier {
        COPPER(Rarity.COMMON, 1),
        IRON(Rarity.UNCOMMON, 2),
        GOLD(Rarity.RARE, 3);

        private final Rarity rarity;
        private final int tierIndex;

        private FloppyTier(Rarity rarity, int index) {
            this.rarity = rarity;
            this.tierIndex = index;
        }

        public Rarity getRarity() {
            return this.rarity;
        }

        public int index() {
            return this.tierIndex;
        }

        public static FloppyTier fromName(String name) {
            return switch (name.toLowerCase(Locale.ROOT)) {
                case "copper" -> COPPER;
                case "iron" -> IRON;
                case "gold" -> GOLD;
                default -> COPPER;
            };
        }
    }

    static final class TierColors {
        TierColors() {
        }

        static TextColor forTier(String tier) {
            return switch (tier) {
                case "copper" -> TextColor.fromRgb((int)12088115);
                case "iron" -> TextColor.fromRgb((int)0xC0C0C0);
                case "gold" -> TextColor.fromRgb((int)16766720);
                default -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE);
            };
        }
    }

    public static final class DiskHooks {
        public static void applyPrimaryYieldBonus(List<ItemStack> drops, Block block, ByteBuddyEntity byteBuddy, float bonusChance) {
            int rolls;
            if (bonusChance > 0.0f && block instanceof CropBlock && (rolls = DiskHooks.totalRollsFromChance(byteBuddy.level(), bonusChance)) > 0) {
                for (ItemStack itemStack : drops) {
                    if (!DiskHooks.isPrimaryProduce(itemStack)) continue;
                    for (int i = 0; i < rolls; ++i) {
                        if (itemStack.getCount() < itemStack.getMaxStackSize()) {
                            itemStack.grow(1);
                            continue;
                        }
                        Containers.dropItemStack((Level)byteBuddy.level(), (double)byteBuddy.getX(), (double)byteBuddy.getY(), (double)byteBuddy.getZ(), (ItemStack)new ItemStack((ItemLike)itemStack.getItem(), 1));
                    }
                }
            }
        }

        public static void tryGiveByproduct(ByteBuddyEntity byteBuddy, ByteBuddyEntity.TaskType taskType, BlockPos blockPos) {
            int rolls;
            float byproductChance = byteBuddy.byproductChance();
            if (byproductChance > 0.0f && (rolls = DiskHooks.totalRollsFromChance(byteBuddy.level(), byproductChance)) > 0) {
                for (int i = 0; i < rolls; ++i) {
                    ItemStack leftover;
                    ItemStack byProductStack;
                    switch (taskType) {
                        case HARVEST: {
                            ItemStack itemStack = new ItemStack((ItemLike)Items.WHEAT_SEEDS, 1);
                            break;
                        }
                        case FORESTRY: {
                            ItemStack itemStack;
                            if (byteBuddy.level().random.nextFloat() < 0.3f) {
                                itemStack = new ItemStack((ItemLike)Items.OAK_SAPLING);
                                break;
                            }
                            itemStack = new ItemStack((ItemLike)Items.STICK);
                            break;
                        }
                        case MINE: {
                            ItemStack itemStack = new ItemStack((ItemLike)Items.FLINT, 1);
                            break;
                        }
                        case SHEAR: {
                            ItemStack itemStack = new ItemStack((ItemLike)Items.STRING, 1);
                            break;
                        }
                        case MILK: {
                            ItemStack itemStack = new ItemStack((ItemLike)Items.LEATHER, 1);
                            break;
                        }
                        case COMBAT: {
                            ItemStack itemStack = new ItemStack((ItemLike)Items.BONE, 1);
                            break;
                        }
                        default: {
                            ItemStack itemStack = byProductStack = ItemStack.EMPTY;
                        }
                    }
                    if (byProductStack.isEmpty() || (leftover = InventoryUtil.mergeInto(byteBuddy.getMainInv(), byProductStack)).isEmpty()) continue;
                    Containers.dropItemStack((Level)byteBuddy.level(), (double)((double)blockPos.getX() + 0.5), (double)((double)blockPos.getY() + 0.5), (double)((double)blockPos.getZ() + 0.5), (ItemStack)leftover);
                }
            }
        }

        private static int totalRollsFromChance(Level level, float chance) {
            int guaranteed = (int)Math.floor(chance);
            float fractional = chance - (float)guaranteed;
            int extra = 0;
            if (fractional > 0.0f && level.random.nextFloat() < fractional) {
                extra = 1;
            }
            return guaranteed + extra;
        }

        public static void applyDiskHealthBoost(ByteBuddyEntity byteBuddy, float healthBoostPct) {
            AttributeInstance attribute = byteBuddy.getAttribute(Attributes.MAX_HEALTH);
            if (attribute != null) {
                double oldMax = attribute.getValue();
                AttributeModifierUtil.removeModifier((LivingEntity)byteBuddy, (Holder<Attribute>)Attributes.MAX_HEALTH, "disk_health");
                if (healthBoostPct > 0.0f) {
                    AttributeModifierUtil.applyPermanentModifier((LivingEntity)byteBuddy, (Holder<Attribute>)Attributes.MAX_HEALTH, "disk_health", healthBoostPct, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
                }
                float newHealth = DiskHooks.getNewHealth(byteBuddy, attribute, oldMax);
                byteBuddy.setHealth(newHealth);
            }
        }

        private static float getNewHealth(ByteBuddyEntity byteBuddy, AttributeInstance attribute, double oldMax) {
            float newHealth;
            double newMax = attribute.getValue();
            float current = byteBuddy.getHealth();
            if (oldMax > 0.0) {
                float ratio = current / (float)oldMax;
                newHealth = ratio * (float)newMax;
            } else {
                newHealth = (float)newMax;
            }
            if (newHealth < 1.0f) {
                newHealth = 1.0f;
            }
            if (newHealth > (float)newMax) {
                newHealth = (float)newMax;
            }
            return newHealth;
        }

        public static void trySpawnHologram(ByteBuddyEntity byteBuddy, ByteBuddyEntity.TaskType taskType) {
            Level level;
            boolean hologramEnabled = byteBuddy.hologramEnabled();
            float configuredChance = byteBuddy.hologramChance();
            float finalChance = configuredChance > 0.0f ? configuredChance : 0.25f;
            float percentRolled = byteBuddy.level().random.nextFloat();
            BlockPos buddyPos = byteBuddy.getOnPos();
            boolean passed = false;
            if (hologramEnabled && percentRolled < finalChance) {
                passed = true;
            }
            if (passed && (level = byteBuddy.level()) instanceof ServerLevel) {
                ServerPlayer owner;
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos spawnBlockPos = buddyPos;
                boolean validPos = false;
                int maxRadius = 3;
                for (int radius = 1; radius <= maxRadius; ++radius) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        for (int dx = -radius; dx <= radius; ++dx) {
                            BlockPos candidate;
                            boolean standableTerrain;
                            boolean onPerimeter;
                            boolean bl = onPerimeter = Math.abs(dx) == radius || Math.abs(dz) == radius;
                            if (!onPerimeter || !(standableTerrain = ByteBuddyEntity.isStandableTerrain((Level)serverLevel, candidate = buddyPos.offset(dx, 0, dz)))) continue;
                            spawnBlockPos = candidate.immutable();
                            validPos = true;
                            dx = radius;
                            dz = radius;
                        }
                    }
                    if (!validPos) continue;
                    radius = maxRadius;
                }
                if (!validPos) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        BlockPos candidate;
                        boolean standableTerrain;
                        if (dy == 0 || !(standableTerrain = ByteBuddyEntity.isStandableTerrain((Level)serverLevel, candidate = buddyPos.above(dy)))) continue;
                        spawnBlockPos = candidate.immutable();
                        validPos = true;
                    }
                }
                for (int i = 0; i < 12; ++i) {
                    double particleInterval = Math.PI * 2 * (double)i / 12.0;
                    serverLevel.sendParticles((ParticleOptions)BluestoneOreBlock.BLUESTONE, (double)spawnBlockPos.getX() + 0.5 + Math.cos(particleInterval) * 0.5, (double)spawnBlockPos.getY() + 0.1, (double)spawnBlockPos.getZ() + 0.5 + Math.sin(particleInterval) * 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
                serverLevel.playSound(null, spawnBlockPos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 0.6f, 1.5f);
                EntityType<HologramBuddyEntity> hologramType = ModEntities.HOLOBUDDY.get();
                int lifetimeTicks = 200;
                HologramBuddyEntity hologram = HologramBuddyEntity.spawnFrom(byteBuddy, hologramType, spawnBlockPos, lifetimeTicks);
                if (hologram == null || (owner = byteBuddy.getOwner(serverLevel)) != null) {
                    // empty if block
                }
            }
        }

        private static boolean isPrimaryProduce(ItemStack st) {
            return st.is(Items.WHEAT) || st.is(Items.CARROT) || st.is(Items.POTATO) || st.is(Items.BEETROOT);
        }
    }

    public static final class DiskEffects {
        private float radiusMultiplier = 1.0f;
        private float energyMultiplier = 1.0f;
        private float speedMultiplier = 1.0f;
        private float wearMultiplier = 1.0f;
        private float yieldBoostChance = 0.0f;
        private float byprodChance = 0.0f;
        private float healthBoostPct = 0.0f;
        private boolean hologramEnabled = false;
        private float hologramChance = 0.0f;
        private boolean supportAuraEnabled = false;
        private float supportAuraPower = 0.0f;

        public void recomputeFrom(ItemStackHandler upgrades) {
            this.radiusMultiplier = 1.0f;
            this.energyMultiplier = 1.0f;
            this.speedMultiplier = 1.0f;
            this.wearMultiplier = 1.0f;
            this.yieldBoostChance = 0.0f;
            this.byprodChance = 0.0f;
            this.healthBoostPct = 0.0f;
            this.hologramEnabled = false;
            this.hologramChance = 0.0f;
            this.supportAuraEnabled = false;
            this.supportAuraPower = 0.0f;
            block70: for (int i = 0; i < upgrades.getSlots(); ++i) {
                Item item;
                ItemStack inSlot = upgrades.getStackInSlot(i);
                if (inSlot.isEmpty() || !((item = inSlot.getItem()) instanceof FloppyDiskItem)) continue;
                FloppyDiskItem disk = (FloppyDiskItem)item;
                FloppyTier tier = disk.getTier();
                switch (disk.colorKey) {
                    case "blue": {
                        this.radiusMultiplier *= (switch (tier.ordinal()) {
                            default -> throw new MatchException(null, null);
                            case 0 -> 1.2f;
                            case 1 -> 1.35f;
                            case 2 -> 1.5f;
                        });
                        continue block70;
                    }
                    case "green": {
                        this.energyMultiplier *= (switch (tier.ordinal()) {
                            default -> throw new MatchException(null, null);
                            case 0 -> 0.9f;
                            case 1 -> 0.8f;
                            case 2 -> 0.7f;
                        });
                        continue block70;
                    }
                    case "red": {
                        this.speedMultiplier *= (switch (tier.ordinal()) {
                            default -> throw new MatchException(null, null);
                            case 0 -> 1.2f;
                            case 1 -> 1.35f;
                            case 2 -> 1.5f;
                        });
                        this.energyMultiplier *= (switch (tier.ordinal()) {
                            default -> throw new MatchException(null, null);
                            case 0 -> 1.3f;
                            case 1 -> 1.5f;
                            case 2 -> 1.7f;
                        });
                        continue block70;
                    }
                    case "black": {
                        this.wearMultiplier *= (switch (tier.ordinal()) {
                            default -> throw new MatchException(null, null);
                            case 0 -> 0.85f;
                            case 1 -> 0.7f;
                            case 2 -> 0.55f;
                        });
                        this.healthBoostPct += (switch (tier.ordinal()) {
                            default -> throw new MatchException(null, null);
                            case 0 -> 1.0f;
                            case 1 -> 1.5f;
                            case 2 -> 2.0f;
                        });
                        continue block70;
                    }
                    case "purple": {
                        this.yieldBoostChance += (switch (tier.ordinal()) {
                            default -> throw new MatchException(null, null);
                            case 0 -> 0.33f;
                            case 1 -> 0.425f;
                            case 2 -> 0.5f;
                        });
                        continue block70;
                    }
                    case "yellow": {
                        this.byprodChance += (switch (tier.ordinal()) {
                            default -> throw new MatchException(null, null);
                            case 0 -> 0.5f;
                            case 1 -> 0.625f;
                            case 2 -> 0.85f;
                        });
                        continue block70;
                    }
                    case "pink": {
                        this.supportAuraEnabled = true;
                        this.supportAuraPower += (switch (tier.ordinal()) {
                            default -> throw new MatchException(null, null);
                            case 0 -> 0.2f;
                            case 1 -> 0.35f;
                            case 2 -> 0.5f;
                        });
                        continue block70;
                    }
                    case "cyan": {
                        this.hologramEnabled = true;
                        this.hologramChance += (switch (tier.ordinal()) {
                            default -> throw new MatchException(null, null);
                            case 0 -> 0.125f;
                            case 1 -> 0.175f;
                            case 2 -> 0.25f;
                        });
                    }
                }
            }
            this.energyMultiplier = Mth.clamp((float)this.energyMultiplier, (float)0.4f, (float)5.0f);
            this.speedMultiplier = Mth.clamp((float)this.speedMultiplier, (float)0.8f, (float)5.0f);
            this.wearMultiplier = Mth.clamp((float)this.wearMultiplier, (float)0.25f, (float)1.5f);
            this.yieldBoostChance = Mth.clamp((float)this.yieldBoostChance, (float)0.0f, (float)2.0f);
            this.byprodChance = Mth.clamp((float)this.byprodChance, (float)0.0f, (float)3.4f);
            this.hologramChance = Mth.clamp((float)this.hologramChance, (float)0.0f, (float)1.0f);
            this.supportAuraPower = Mth.clamp((float)this.supportAuraPower, (float)0.0f, (float)1.0f);
            this.healthBoostPct = Mth.clamp((float)this.healthBoostPct, (float)0.0f, (float)8.0f);
        }

        public float radiusMultiplier() {
            return this.radiusMultiplier;
        }

        public float energyCostMultiplier() {
            return this.energyMultiplier;
        }

        public float actionSpeedMultiplier() {
            return this.speedMultiplier;
        }

        public float toolWearMultiplier() {
            return this.wearMultiplier;
        }

        public float yieldPrimaryChance() {
            return this.yieldBoostChance;
        }

        public float secondaryByproductChance() {
            return this.byprodChance;
        }

        public float healthBoostPercent() {
            return this.healthBoostPct;
        }

        public boolean hologramEnabled() {
            return this.hologramEnabled;
        }

        public float hologramChance() {
            return this.hologramChance;
        }

        public boolean supportAuraEnabled() {
            return this.supportAuraEnabled;
        }

        public float supportAuraPower() {
            return this.supportAuraPower;
        }
    }
}

