/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.component.ModDataComponents;
import net.turtleboi.bytebuddies.effects.ModEffects;
import net.turtleboi.bytebuddies.entity.entities.SwordSweepEntity;
import org.jetbrains.annotations.NotNull;

public class TerrabladeItem
extends SwordItem {
    public static final int MAX_CHARGE = 100;

    public TerrabladeItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        boolean active = TerrabladeItem.isActive(stack);
        if (active || player.hasEffect(ModEffects.SUPERCHARGED)) {
            SwordSweepEntity projectile = new SwordSweepEntity(level);
            projectile.setOwner((Entity)player);
            projectile.setPos(player.getX(), player.getY() + (double)(player.getBbHeight() / 2.0f), player.getZ());
            Vec3 lookAngle = player.getLookAngle();
            float velocity = 1.63f;
            projectile.shoot(lookAngle.x, lookAngle.y, lookAngle.z, velocity, 0.0f);
            Vec3 vec3 = player.getKnownMovement();
            projectile.setDeltaMovement(projectile.getDeltaMovement().add(vec3.x, player.onGround() ? 0.0 : vec3.y, vec3.z));
            projectile.setProjectileDamage((float)player.getAttributeValue(Attributes.ATTACK_DAMAGE));
            level.addFreshEntity((Entity)projectile);
            player.getCooldowns().addCooldown((Item)this, 10);
            player.swing(hand, true);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)false);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (level.isClientSide || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int charge = TerrabladeItem.getCharge(stack);
        if (!TerrabladeItem.isActive(stack) && charge >= 100) {
            TerrabladeItem.setActive(stack, true);
            int effectDuration = TerrabladeItem.getCharge(stack);
            player.addEffect(new MobEffectInstance(ModEffects.SUPERCHARGED, effectDuration, 0, false, true, true));
            player.swing(player.getUsedItemHand(), true);
        }
        if (TerrabladeItem.isActive(stack)) {
            int effectDuration;
            if (charge <= 0) {
                TerrabladeItem.setActive(stack, false);
                player.removeEffect(ModEffects.SUPERCHARGED);
                return;
            }
            int newCharge = charge - 1;
            TerrabladeItem.setCharge(stack, newCharge);
            MobEffectInstance mobEffectInstance = player.getEffect(ModEffects.SUPERCHARGED);
            int n = effectDuration = mobEffectInstance == null ? 0 : mobEffectInstance.getDuration();
            if (effectDuration != newCharge) {
                player.addEffect(new MobEffectInstance(ModEffects.SUPERCHARGED, newCharge, 0, false, true, true));
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        int charge = (Integer)stack.getOrDefault((DataComponentType)ModDataComponents.CHARGE.get(), (Object)0);
        tooltip.add((Component)Component.literal((String)("Charge: " + charge + " / 100")).withStyle(ChatFormatting.AQUA));
    }

    public static int getCharge(ItemStack itemStack) {
        Integer charge = (Integer)itemStack.get(ModDataComponents.CHARGE);
        return charge == null ? 0 : Mth.clamp((int)charge, (int)0, (int)100);
    }

    public static void setCharge(ItemStack itemStack, int charge) {
        itemStack.set(ModDataComponents.CHARGE, (Object)Mth.clamp((int)charge, (int)0, (int)100));
    }

    public static boolean isActive(ItemStack itemStack) {
        Boolean isSuperCharged = (Boolean)itemStack.get((DataComponentType)ModDataComponents.SUPER_CHARGED.get());
        return isSuperCharged != null && isSuperCharged != false;
    }

    public static void setActive(ItemStack itemStack, boolean active) {
        itemStack.set((DataComponentType)ModDataComponents.SUPER_CHARGED.get(), (Object)active);
    }
}

