/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.turtleboi.bytebuddies.screen.custom.menu.GeneratorMenu;
import org.jetbrains.annotations.NotNull;

public class GeneratorScreen
extends AbstractContainerScreen<GeneratorMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"textures/gui/generator_gui.png");
    private static final ResourceLocation GUI_ADDONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"textures/gui/gui_addons.png");
    private static final int energyX = 40;
    private static final int energyY = 6;
    private static final int energyWidth = 16;
    private static final int energyHeight = 52;
    private static final int energyEmptyU = 16;
    private static final int energyEmptyV = 0;
    private static final int energyFullU = 0;
    private static final int energyFullV = 0;
    private boolean debugEnergyOverride = false;
    private double debugFillPct = 0.5;

    public GeneratorScreen(GeneratorMenu generatorMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)generatorMenu, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 205;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.drawEnergyBar(guiGraphics, x + 40, y + 6);
        this.drawProgressBar(guiGraphics, x + 92, y + 22);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.drawEnergyToolTip(guiGraphics, mouseX, mouseY);
    }

    private void drawEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int filled;
        guiGraphics.blit(GUI_ADDONS_TEXTURE, x, y, 16.0f, 0.0f, 16, 52, 128, 128);
        if (this.debugEnergyOverride) {
            filled = Mth.clamp((int)((int)Math.round(this.debugFillPct * 52.0)), (int)0, (int)52);
        } else {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            filled = Mth.clamp((int)((int)Math.round((double)energy * 52.0 / (double)energyMax)), (int)0, (int)52);
        }
        if (filled <= 0) {
            return;
        }
        int dy = 52 - filled;
        int drawY = y + dy;
        int vFill = 0 + dy;
        guiGraphics.blit(GUI_ADDONS_TEXTURE, x, drawY, 0.0f, (float)vFill, 16, filled, 128, 128);
    }

    private void drawEnergyToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int absoluteX = this.leftPos + 40;
        int absoluteY = this.topPos + 6;
        if (this.isMouseInArea(mouseX, mouseY, absoluteX, absoluteY, 16, 52)) {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            MutableComponent line1 = Component.literal((String)(numberFormat.format(energy) + " / " + numberFormat.format(energyMax) + " FE"));
            guiGraphics.renderTooltip(this.font, List.of(line1), Optional.empty(), mouseX, mouseY);
        }
    }

    private void drawProgressBar(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(GUI_TEXTURE, x, y, 188.0f, 0.0f, 12, 15, 256, 256);
        long progress = this.getProgressSafe();
        long progressMax = Math.max(1L, this.getMaxProgressSafe());
        long remaining = progressMax - progress;
        int filled = 0;
        if (progressMax != 1L) {
            filled = Mth.clamp((int)((int)Math.round((double)remaining * 15.0 / (double)progressMax)), (int)0, (int)15);
        }
        int dy = 15 - filled;
        int drawY = y + dy;
        guiGraphics.blit(GUI_TEXTURE, x, drawY, 176.0f, (float)dy, 12, filled, 256, 256);
    }

    private long getProgressSafe() {
        try {
            return Math.max(0, ((GeneratorMenu)this.menu).getProgress());
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private long getMaxProgressSafe() {
        try {
            return Math.max(1, ((GeneratorMenu)this.menu).getMaxProgress());
        }
        catch (Throwable t) {
            return 1L;
        }
    }

    private long getEnergyStoredSafe() {
        try {
            return Math.max(0, ((GeneratorMenu)this.menu).getEnergyStored());
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private long getMaxEnergyStoredSafe() {
        try {
            return Math.max(1, ((GeneratorMenu)this.menu).getMaxEnergyStored());
        }
        catch (Throwable t) {
            return 1L;
        }
    }

    private boolean isMouseInArea(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }
}

