/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.turtleboi.bytebuddies.screen.custom.menu.SolarPanelMenu;
import org.jetbrains.annotations.NotNull;

public class SolarPanelScreen
extends AbstractContainerScreen<SolarPanelMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"textures/gui/solar_panel_gui.png");
    private static final ResourceLocation GUI_ADDONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"textures/gui/gui_addons.png");
    private static final int energyX = 80;
    private static final int energyY = 23;
    private static final int energyWidth = 16;
    private static final int energyHeight = 52;
    private static final int energyEmptyU = 16;
    private static final int energyEmptyV = 0;
    private static final int energyFullU = 0;
    private static final int energyFullV = 0;
    private boolean debugEnergyOverride = false;
    private double debugFillPct = 0.5;

    public SolarPanelScreen(SolarPanelMenu solarPanelMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)solarPanelMenu, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 205;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.drawEnergyBar(guiGraphics, x + 80, y + 23);
        this.drawGenerationBolt(guiGraphics, x + 82, y + 5);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.drawEnergyToolTip(guiGraphics, mouseX, mouseY);
    }

    private void drawEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int filled;
        guiGraphics.blit(GUI_ADDONS_TEXTURE, x, y, 16.0f, 0.0f, 16, 52, 128, 128);
        if (this.debugEnergyOverride) {
            filled = Mth.clamp((int)((int)Math.round(this.debugFillPct * 52.0)), (int)0, (int)52);
        } else {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            filled = Mth.clamp((int)((int)Math.round((double)energy * 52.0 / (double)energyMax)), (int)0, (int)52);
        }
        if (filled <= 0) {
            return;
        }
        int dy = 52 - filled;
        int drawY = y + dy;
        int vFill = 0 + dy;
        guiGraphics.blit(GUI_ADDONS_TEXTURE, x, drawY, 0.0f, (float)vFill, 16, filled, 128, 128);
    }

    private void drawEnergyToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int absoluteX = this.leftPos + 80;
        int absoluteY = this.topPos + 23;
        if (this.isMouseInArea(mouseX, mouseY, absoluteX, absoluteY, 16, 52)) {
            long energy = this.getEnergyStoredSafe();
            long energyMax = Math.max(1L, this.getMaxEnergyStoredSafe());
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            MutableComponent line1 = Component.literal((String)(numberFormat.format(energy) + " / " + numberFormat.format(energyMax) + " FE"));
            guiGraphics.renderTooltip(this.font, List.of(line1), Optional.empty(), mouseX, mouseY);
        }
    }

    private void drawGenerationBolt(GuiGraphics guiGraphics, int x, int y) {
        if (this.getGenerating()) {
            guiGraphics.blit(GUI_TEXTURE, x, y, 176.0f, 0.0f, 12, 15, 256, 256);
        } else {
            guiGraphics.blit(GUI_TEXTURE, x, y, 188.0f, 0.0f, 12, 15, 256, 256);
        }
    }

    private long getEnergyStoredSafe() {
        try {
            return Math.max(0, ((SolarPanelMenu)this.menu).getEnergyStored());
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private long getMaxEnergyStoredSafe() {
        try {
            return Math.max(1, ((SolarPanelMenu)this.menu).getMaxEnergyStored());
        }
        catch (Throwable t) {
            return 1L;
        }
    }

    private boolean getGenerating() {
        try {
            return ((SolarPanelMenu)this.menu).getGeneratingBinary();
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean isMouseInArea(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }
}

