/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom.menu;

import com.mojang.datafixers.util.Pair;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.init.ModTags;
import net.turtleboi.bytebuddies.screen.ModMenuTypes;
import net.turtleboi.bytebuddies.screen.custom.slot.BuddySlot;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import org.jetbrains.annotations.NotNull;

public class ByteBuddyDoubleMenu
extends AbstractContainerMenu {
    public final ByteBuddyEntity byteBuddy;
    public final Inventory playerInv;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 36;
    private static final int SLOT_SIZE = 18;

    public ByteBuddyDoubleMenu(int containerId, Inventory playerInv, ByteBuddyEntity byteBuddy) {
        super((MenuType)ModMenuTypes.BUDDY_DOUBLE_MENU.get(), containerId);
        this.playerInv = playerInv;
        this.byteBuddy = byteBuddy;
        if (!playerInv.player.level().isClientSide && this.byteBuddy != null) {
            this.byteBuddy.onMenuOpened(playerInv.player);
        }
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.addBuddyInventory();
        this.addBuddyAugments();
        this.addBuddyUpgrades();
        this.addBuddyClipboard();
    }

    public static ByteBuddyDoubleMenu clientFactory(int buddyId, Inventory inventory, FriendlyByteBuf byteBuf) {
        ByteBuddyEntity byteBuddy;
        int entityId = byteBuf.readInt();
        Entity entity = inventory.player.level().getEntity(entityId);
        return new ByteBuddyDoubleMenu(buddyId, inventory, entity instanceof ByteBuddyEntity ? (byteBuddy = (ByteBuddyEntity)entity) : null);
    }

    public LivingEntity getByteBuddy() {
        return this.byteBuddy;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        if (!player.level().isClientSide && this.byteBuddy != null) {
            this.byteBuddy.onMenuClosed(player);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 72, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 72) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.byteBuddy != null && this.byteBuddy.isAlive() && (double)player.distanceTo((Entity)this.byteBuddy) < 4.0;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int startX = 44;
        int startY = 145;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, startX + col * 18, startY + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int startX = 44;
        int startY = 203;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, startX + i * 18, startY));
        }
    }

    private void addBuddyInventory() {
        if (this.byteBuddy == null) {
            return;
        }
        int baseX = 71;
        int baseY = 63;
        int slot = 9;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.byteBuddy.getMainInv(), slot++, baseX + col * 18, baseY + row * 18));
            }
        }
        int add9X = 125;
        for (int i = 18; i <= 26; ++i) {
            int idx = i - 18;
            int x = add9X + idx % 3 * 18;
            int y = baseY + idx / 3 * 18;
            this.addSlot((Slot)new BuddySlot((IItemHandler)this.byteBuddy.getMainInv(), i, x, y, () -> this.byteBuddy.getStorageCellsExtraSlots() >= 9));
        }
        int add18X = 10000;
        for (int i = 27; i <= 35; ++i) {
            int idx = i - 27;
            int x = add18X + idx % 3 * 18;
            int y = baseY + idx / 3 * 18;
            this.addSlot((Slot)new BuddySlot((IItemHandler)this.byteBuddy.getMainInv(), i, x, y, () -> this.byteBuddy.getStorageCellsExtraSlots() == 18));
        }
    }

    private void addBuddyAugments() {
        if (this.byteBuddy == null) {
            return;
        }
        int startX = 33;
        int startY = 54;
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.byteBuddy.getMainInv(), 0, startX, startY){

            public boolean mayPlace(ItemStack itemStack) {
                return ByteBuddyEntity.isAnyTool(itemStack);
            }

            public int getMaxStackSize() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/empty_slot_tool"));
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.byteBuddy.getMainInv(), 1, startX, startY + 18){

            public boolean mayPlace(ItemStack itemStack) {
                ItemStack other;
                if (itemStack.isEmpty()) {
                    return false;
                }
                if (!itemStack.is(ModTags.Items.AUGMENT)) {
                    return false;
                }
                return !itemStack.is(ModTags.Items.PLATING) || (other = ByteBuddyDoubleMenu.this.byteBuddy.getMainInv().getStackInSlot(2)).isEmpty() || !other.is(ModTags.Items.PLATING);
            }

            public int getMaxStackSize() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/empty_slot_augment"));
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.byteBuddy.getMainInv(), 2, startX, startY + 36){

            public boolean mayPlace(ItemStack itemStack) {
                ItemStack other;
                if (itemStack.isEmpty()) {
                    return false;
                }
                if (!itemStack.is(ModTags.Items.AUGMENT)) {
                    return false;
                }
                return !itemStack.is(ModTags.Items.PLATING) || (other = ByteBuddyDoubleMenu.this.byteBuddy.getMainInv().getStackInSlot(1)).isEmpty() || !other.is(ModTags.Items.PLATING);
            }

            public int getMaxStackSize() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/empty_slot_augment"));
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.byteBuddy.getMainInv(), 3, startX, startY + 54){

            public boolean mayPlace(ItemStack itemStack) {
                return InventoryUtil.isBattery(itemStack);
            }

            public int getMaxStackSize() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/empty_slot_battery"));
            }
        });
    }

    private void addBuddyUpgrades() {
        if (this.byteBuddy == null) {
            return;
        }
        int startX = 199;
        int startY = 54;
        for (int u = 4; u < 8; ++u) {
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.byteBuddy.getMainInv(), u, startX, startY + (u - 4) * 18){

                public boolean mayPlace(ItemStack itemStack) {
                    return InventoryUtil.isFloppyDisk(itemStack);
                }

                public int getMaxStackSize() {
                    return 1;
                }

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/empty_slot_floppy_disk"));
                }
            });
        }
    }

    private void addBuddyClipboard() {
        if (this.byteBuddy == null) {
            return;
        }
        int startX = 159;
        int startY = 17;
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.byteBuddy.getMainInv(), 8, startX, startY){

            public boolean mayPlace(ItemStack itemStack) {
                return InventoryUtil.isClipboard(itemStack);
            }

            public int getMaxStackSize() {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"item/empty_slot_clipboard"));
            }
        });
    }

    public boolean farmingEnabled() {
        return this.byteBuddy != null && this.byteBuddy.isFarmingEnabled();
    }

    public boolean harvestEnabled() {
        return this.byteBuddy != null && this.byteBuddy.isHarvestEnabled();
    }

    public boolean plantEnabled() {
        return this.byteBuddy != null && this.byteBuddy.isPlantEnabled();
    }

    public boolean tillEnabled() {
        return this.byteBuddy != null && this.byteBuddy.isTillEnabled();
    }

    public int getEnergyStored() {
        if (this.byteBuddy.level().isClientSide) {
            return this.byteBuddy.getSyncedEnergy();
        }
        return this.byteBuddy.getEnergyStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.byteBuddy != null ? this.byteBuddy.getEnergyStorage().getMaxEnergyStored() : 0;
    }

    public double getHealth() {
        if (this.byteBuddy.level().isClientSide) {
            return this.byteBuddy.getHealth();
        }
        return 0.0;
    }

    public double getMaxHealth() {
        return this.byteBuddy != null ? (double)this.byteBuddy.getMaxHealth() : 0.0;
    }

    public void broadcastChanges() {
        boolean mismatch;
        super.broadcastChanges();
        Player player = this.playerInv.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (this.byteBuddy == null || !this.byteBuddy.isAlive()) {
            return;
        }
        int extraSlots = this.byteBuddy.getStorageCellsExtraSlots();
        boolean bl = mismatch = extraSlots != 9;
        if (mismatch) {
            serverPlayer.closeContainer();
            ByteBuddyEntity.openStorageMenu(serverPlayer, this.byteBuddy);
        }
    }
}

