/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.util;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.turtleboi.bytebuddies.effects.ModEffects;

public class StunThornsHandler {
    public static void setStunner(LivingEntity livingEntity, Entity stunner) {
        if (!livingEntity.getPersistentData().contains("StunnedBy")) {
            livingEntity.getPersistentData().putUUID("StunnedBy", stunner.getUUID());
        }
    }

    public static void stunByEntity(LivingEntity livingEntity, LivingEntity stunner) {
        StunThornsHandler.setStunner(livingEntity, (Entity)stunner);
        Level level = stunner.level();
        if (stunner instanceof Player) {
            Player player = (Player)stunner;
            livingEntity.hurt(level.damageSources().playerAttack(player), 6.0f);
        } else {
            livingEntity.hurt(level.damageSources().mobAttack(stunner), 6.0f);
        }
        MobEffectInstance mobEffectInstance = new MobEffectInstance(ModEffects.STUNNED, 100);
        livingEntity.addEffect(mobEffectInstance, (Entity)stunner);
    }
}

