/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.util;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public final class ToolUtil {
    public static void applyToolWear(ByteBuddyEntity byteBuddy, ToolType toolType, float wearMultiplier) {
        if (toolType == ToolType.EMPTY_HAND) {
            return;
        }
        int slot = byteBuddy.getHeldToolSlot();
        if (slot < 0) {
            return;
        }
        ItemStack toolStack = byteBuddy.getHeldTool();
        if (!toolStack.isDamageableItem()) {
            return;
        }
        boolean baseWear = true;
        int damageValue = Math.max(1, Math.round((float)baseWear * wearMultiplier));
        ItemStack heldTool = byteBuddy.getHeldTool();
        if (!heldTool.isEmpty() && heldTool.isDamageableItem()) {
            heldTool.hurtAndBreak(damageValue, (LivingEntity)byteBuddy, EquipmentSlot.MAINHAND);
            byteBuddy.getMainInv().setStackInSlot(slot, heldTool);
        }
    }

    public static boolean matchesToolType(ItemStack toolStack, ToolType toolType) {
        Item toolItem = toolStack.getItem();
        return switch (toolType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> toolItem instanceof HoeItem;
            case 1 -> toolItem instanceof AxeItem;
            case 2 -> toolItem instanceof PickaxeItem;
            case 3 -> toolItem instanceof ShovelItem;
            case 4 -> toolItem instanceof ShearsItem;
            case 5 -> toolItem instanceof SwordItem;
            case 6 -> toolItem instanceof BowItem;
            case 7 -> toolItem instanceof CrossbowItem;
            case 8 -> false;
        };
    }

    public static enum ToolType {
        HOE,
        AXE,
        PICKAXE,
        SHOVEL,
        SHEARS,
        SWORD,
        BOW,
        CROSSBOW,
        EMPTY_HAND;

    }
}

