/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.worldgen;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.turtleboi.bytebuddies.block.ModBlocks;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ALUMINUM_ORE_KEY = ModConfiguredFeatures.registerKey("aluminum_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUESTONE_ORE_KEY = ModConfiguredFeatures.registerKey("bluestone_ore");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> overworldAluminumOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.BAUXITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_BAUXITE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldBluestoneOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.BLUESTONE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_BLUESTONE_ORE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, ALUMINUM_ORE_KEY, Feature.ORE, new OreConfiguration(overworldAluminumOres, 5));
        ModConfiguredFeatures.register(context, BLUESTONE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldBluestoneOres, 7));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

