/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.turtleboi.bytebuddies.worldgen.ModConfiguredFeatures;
import net.turtleboi.bytebuddies.worldgen.ModOrePlacement;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> ALUMINUM_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("aluminum_ore_placed");
    public static final ResourceKey<PlacedFeature> ALUMINUM_ORE_ABUNDANT_PLACED_KEY = ModPlacedFeatures.registerKey("aluminum_ore_abundant_placed");
    public static final ResourceKey<PlacedFeature> ALUMINUM_ORE_RARE_PLACED_KEY = ModPlacedFeatures.registerKey("aluminum_ore_rare_placed");
    public static final ResourceKey<PlacedFeature> BLUESTONE_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("bluestone_ore_placed");
    public static final ResourceKey<PlacedFeature> BLUESTONE_ORE_LOWER_PLACED_KEY = ModPlacedFeatures.registerKey("bluestone_ore_lower_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, ALUMINUM_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.ALUMINUM_ORE_KEY), ModOrePlacement.orePlacement((PlacementModifier)CountPlacement.of((int)8), (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, ALUMINUM_ORE_ABUNDANT_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.ALUMINUM_ORE_KEY), ModOrePlacement.orePlacement((PlacementModifier)CountPlacement.of((int)16), (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)40), (VerticalAnchor)VerticalAnchor.absolute((int)120))));
        ModPlacedFeatures.register(context, ALUMINUM_ORE_RARE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.ALUMINUM_ORE_KEY), ModOrePlacement.orePlacement((PlacementModifier)CountPlacement.of((int)4), (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, BLUESTONE_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.BLUESTONE_ORE_KEY), ModOrePlacement.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)15))));
        ModPlacedFeatures.register(context, BLUESTONE_ORE_LOWER_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.BLUESTONE_ORE_KEY), ModOrePlacement.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-32), (VerticalAnchor)VerticalAnchor.aboveBottom((int)32))));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

