/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.ctx;

import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.client.texture.render.TextureCTM;
import team.chisel.ctm.client.util.CTMLogic;

public class TextureContextCTM
implements ITextureContext {
    protected final TextureCTM<?> tex;
    private final EnumMap<Direction, CTMLogic> ctmData = new EnumMap(Direction.class);
    private long data;

    public TextureContextCTM(@NotNull BlockState state, BlockAndTintGetter world, BlockPos pos, TextureCTM<?> tex) {
        this.tex = tex;
        for (Direction face : Direction.values()) {
            CTMLogic ctm = this.createCTM(state);
            ctm.getSubmapIds(world, pos, state, face);
            this.ctmData.put(face, ctm);
            this.data |= ctm.serialized() << face.ordinal() * 10;
        }
    }

    protected CTMLogic createCTM(@NotNull BlockState state) {
        CTMLogic ret = CTMLogic.getInstance();
        this.tex.applyTo(ret.connectionCheck);
        return ret;
    }

    public CTMLogic getCTM(Direction face) {
        return this.ctmData.get(face);
    }

    @Override
    public long getCompressedData() {
        return this.data;
    }
}

