/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;

public class NBTTags {
    public static LayeredRegistryAccess access = RegistryLayer.createRegistryAccess();
    public static MinecraftServer server;

    public static HolderLookup.Provider getProvider() {
        return server.overworld().registryAccess();
    }

    public static void getItemStackList(HolderLookup.Provider lookupProvider, ListTag tagList, NonNullList<ItemStack> items) {
        items.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            try {
                items.set(nbttagcompound.getByte("Slot") & 0xFF, (Object)ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbttagcompound));
                continue;
            }
            catch (ClassCastException e) {
                items.set(nbttagcompound.getInt("Slot"), (Object)ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbttagcompound));
            }
        }
    }

    public static Map<Integer, IItemStack> getIItemStackMap(HolderLookup.Provider lookupProvider, ListTag tagList) {
        HashMap<Integer, IItemStack> list = new HashMap<Integer, IItemStack>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbttagcompound);
            if (item.isEmpty()) continue;
            try {
                list.put(nbttagcompound.getByte("Slot") & 0xFF, NpcAPI.Instance().getIItemStack(item));
                continue;
            }
            catch (ClassCastException e) {
                list.put(nbttagcompound.getInt("Slot"), NpcAPI.Instance().getIItemStack(item));
            }
        }
        return list;
    }

    public static NonNullList<Ingredient> getIngredientList(HolderLookup.Provider lookupProvider, ListTag tagList) {
        NonNullList list = NonNullList.create();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            list.add(nbttagcompound.getByte("Slot") & 0xFF, (Object)Ingredient.of((ItemStack[])new ItemStack[]{ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbttagcompound)}));
        }
        return list;
    }

    public static ArrayList<int[]> getIntegerArraySet(ListTag tagList) {
        ArrayList<int[]> set = new ArrayList<int[]>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag compound = tagList.getCompound(i);
            set.add(compound.getIntArray("Array"));
        }
        return set;
    }

    public static HashMap<Integer, Boolean> getBooleanList(ListTag tagList) {
        HashMap<Integer, Boolean> list = new HashMap<Integer, Boolean>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            list.put(nbttagcompound.getInt("Slot"), nbttagcompound.getBoolean("Boolean"));
        }
        return list;
    }

    public static HashMap<Integer, Integer> getIntegerIntegerMap(ListTag tagList) {
        HashMap<Integer, Integer> list = new HashMap<Integer, Integer>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            list.put(nbttagcompound.getInt("Slot"), nbttagcompound.getInt("Integer"));
        }
        return list;
    }

    public static HashMap<Integer, Float> getFloatIntegerMap(ListTag tagList) {
        HashMap<Integer, Float> list = new HashMap<Integer, Float>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            list.put(nbttagcompound.getInt("Slot"), Float.valueOf(nbttagcompound.getFloat("Integer")));
        }
        return list;
    }

    public static HashMap<Integer, Long> getIntegerLongMap(ListTag tagList) {
        HashMap<Integer, Long> list = new HashMap<Integer, Long>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            list.put(nbttagcompound.getInt("Slot"), nbttagcompound.getLong("Long"));
        }
        return list;
    }

    public static HashSet<Integer> getIntegerSet(ListTag tagList) {
        HashSet<Integer> list = new HashSet<Integer>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            list.add(nbttagcompound.getInt("Integer"));
        }
        return list;
    }

    public static List<Integer> getIntegerList(ListTag tagList) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            list.add(nbttagcompound.getInt("Integer"));
        }
        return list;
    }

    public static HashMap<String, String> getStringStringMap(ListTag tagList) {
        HashMap<String, String> list = new HashMap<String, String>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            list.put(nbttagcompound.getString("Slot"), nbttagcompound.getString("Value"));
        }
        return list;
    }

    public static HashMap<Integer, String> getIntegerStringMap(ListTag tagList) {
        HashMap<Integer, String> list = new HashMap<Integer, String>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            list.put(nbttagcompound.getInt("Slot"), nbttagcompound.getString("Value"));
        }
        return list;
    }

    public static HashMap<String, Integer> getStringIntegerMap(ListTag tagList) {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            list.put(nbttagcompound.getString("Slot"), nbttagcompound.getInt("Value"));
        }
        return list;
    }

    public static HashMap<String, Vector<String>> getVectorMap(ListTag tagList) {
        HashMap<String, Vector<String>> map = new HashMap<String, Vector<String>>();
        for (int i = 0; i < tagList.size(); ++i) {
            Vector<String> values = new Vector<String>();
            CompoundTag nbttagcompound = tagList.getCompound(i);
            ListTag list = nbttagcompound.getList("Values", 10);
            for (int j = 0; j < list.size(); ++j) {
                CompoundTag value = list.getCompound(j);
                values.add(value.getString("Value"));
            }
            map.put(nbttagcompound.getString("Key"), values);
        }
        return map;
    }

    public static List<String> getStringList(ListTag tagList) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            String line = nbttagcompound.getString("Line");
            list.add(line);
        }
        return list;
    }

    public static List<ResourceLocation> getResourceLocationList(ListTag tagList) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            ResourceLocation line = ResourceLocation.tryParse((String)nbttagcompound.getString("Line"));
            list.add(line);
        }
        return list;
    }

    public static String[] getStringArray(ListTag tagList, int size) {
        String[] arr = new String[size];
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            String line = nbttagcompound.getString("Value");
            int slot = nbttagcompound.getInt("Slot");
            arr[slot] = line;
        }
        return arr;
    }

    public static ListTag nbtIntegerArraySet(List<int[]> set) {
        ListTag nbttaglist = new ListTag();
        if (set == null) {
            return nbttaglist;
        }
        for (int[] arr : set) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putIntArray("Array", arr);
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtItemStackList(HolderLookup.Provider lookupProvider, NonNullList<ItemStack> inventory) {
        ListTag nbttaglist = new ListTag();
        for (int slot = 0; slot < inventory.size(); ++slot) {
            ItemStack item = (ItemStack)inventory.get(slot);
            if (item.isEmpty()) continue;
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putByte("Slot", (byte)slot);
            if (!item.isEmpty()) {
                nbttagcompound = (CompoundTag)item.save(lookupProvider, (Tag)nbttagcompound);
            }
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtIItemStackMap(HolderLookup.Provider lookupProvider, Map<Integer, IItemStack> inventory) {
        ListTag nbttaglist = new ListTag();
        if (inventory == null) {
            return nbttaglist;
        }
        for (int slot : inventory.keySet()) {
            IItemStack item = inventory.get(slot);
            if (item == null) continue;
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putByte("Slot", (byte)slot);
            if (!item.isEmpty()) {
                nbttagcompound = (CompoundTag)item.getMCItemStack().save(lookupProvider, (Tag)nbttagcompound);
            }
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtIngredientList(HolderLookup.Provider lookupProvider, NonNullList<Ingredient> inventory) {
        ListTag nbttaglist = new ListTag();
        if (inventory == null) {
            return nbttaglist;
        }
        for (int slot = 0; slot < inventory.size(); ++slot) {
            Ingredient ingredient = (Ingredient)inventory.get(slot);
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putByte("Slot", (byte)slot);
            if (ingredient != null && ingredient.getItems().length > 0 && !ingredient.getItems()[0].isEmpty()) {
                nbttagcompound = (CompoundTag)ingredient.getItems()[0].save(lookupProvider, (Tag)nbttagcompound);
            }
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtBooleanList(HashMap<Integer, Boolean> updatedSlots) {
        ListTag nbttaglist = new ListTag();
        if (updatedSlots == null) {
            return nbttaglist;
        }
        HashMap<Integer, Boolean> inventory2 = updatedSlots;
        for (Integer slot : inventory2.keySet()) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putInt("Slot", slot.intValue());
            nbttagcompound.putBoolean("Boolean", inventory2.get(slot).booleanValue());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtIntegerIntegerMap(Map<Integer, Integer> lines) {
        ListTag nbttaglist = new ListTag();
        if (lines == null) {
            return nbttaglist;
        }
        for (int slot : lines.keySet()) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putInt("Slot", slot);
            nbttagcompound.putInt("Integer", lines.get(slot).intValue());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtFloatMap(Map<Integer, Float> lines) {
        ListTag nbttaglist = new ListTag();
        if (lines == null) {
            return nbttaglist;
        }
        for (int slot : lines.keySet()) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putInt("Slot", slot);
            nbttagcompound.putFloat("Integer", lines.get(slot).floatValue());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtIntegerLongMap(HashMap<Integer, Long> lines) {
        ListTag nbttaglist = new ListTag();
        if (lines == null) {
            return nbttaglist;
        }
        for (int slot : lines.keySet()) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putInt("Slot", slot);
            nbttagcompound.putLong("Long", lines.get(slot).longValue());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtIntegerCollection(Collection<Integer> set) {
        ListTag nbttaglist = new ListTag();
        if (set == null) {
            return nbttaglist;
        }
        for (int slot : set) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putInt("Integer", slot);
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtVectorMap(HashMap<String, Vector<String>> map) {
        ListTag list = new ListTag();
        if (map == null) {
            return list;
        }
        for (String key : map.keySet()) {
            CompoundTag compound = new CompoundTag();
            compound.putString("Key", key);
            ListTag values = new ListTag();
            for (String value : map.get(key)) {
                CompoundTag comp = new CompoundTag();
                comp.putString("Value", value);
                values.add((Object)comp);
            }
            compound.put("Values", (Tag)values);
            list.add((Object)compound);
        }
        return list;
    }

    public static ListTag nbtStringStringMap(HashMap<String, String> map) {
        ListTag nbttaglist = new ListTag();
        if (map == null) {
            return nbttaglist;
        }
        for (String slot : map.keySet()) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putString("Slot", slot);
            nbttagcompound.putString("Value", map.get(slot));
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtStringIntegerMap(Map<String, Integer> map) {
        ListTag nbttaglist = new ListTag();
        if (map == null) {
            return nbttaglist;
        }
        for (String slot : map.keySet()) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putString("Slot", slot);
            nbttagcompound.putInt("Value", map.get(slot).intValue());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static Tag nbtIntegerStringMap(Map<Integer, String> map) {
        ListTag nbttaglist = new ListTag();
        if (map == null) {
            return nbttaglist;
        }
        for (int slot : map.keySet()) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putInt("Slot", slot);
            nbttagcompound.putString("Value", map.get(slot));
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtStringArray(String[] list) {
        ListTag nbttaglist = new ListTag();
        if (list == null) {
            return nbttaglist;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putString("Value", list[i]);
            nbttagcompound.putInt("Slot", i);
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtStringList(List<String> list) {
        ListTag nbttaglist = new ListTag();
        for (String s : list) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putString("Line", s);
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtResourceLocationList(List<ResourceLocation> list) {
        ListTag nbttaglist = new ListTag();
        for (ResourceLocation s : list) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putString("Line", s.toString());
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }

    public static ListTag nbtDoubleList(double ... par1ArrayOfDouble) {
        ListTag nbttaglist = new ListTag();
        double[] adouble = par1ArrayOfDouble;
        int i = par1ArrayOfDouble.length;
        for (int j = 0; j < i; ++j) {
            double d1 = adouble[j];
            nbttaglist.add((Object)DoubleTag.valueOf((double)d1));
        }
        return nbttaglist;
    }

    public static CompoundTag NBTMerge(CompoundTag data, CompoundTag merge) {
        CompoundTag compound = data.copy();
        Set names = merge.getAllKeys();
        for (String name : names) {
            Tag base = merge.get(name);
            if (base.getId() == 10) {
                base = NBTTags.NBTMerge(compound.getCompound(name), (CompoundTag)base);
            }
            compound.put(name, base);
        }
        return compound;
    }

    public static List<ScriptContainer> GetScript(ListTag list, IScriptHandler handler) {
        ArrayList<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compoundd = list.getCompound(i);
            ScriptContainer script = new ScriptContainer(handler);
            script.load(compoundd);
            scripts.add(script);
        }
        return scripts;
    }

    public static ListTag NBTScript(List<ScriptContainer> scripts) {
        ListTag list = new ListTag();
        for (ScriptContainer script : scripts) {
            CompoundTag compound = new CompoundTag();
            script.save(compound);
            list.add((Object)compound);
        }
        return list;
    }

    public static TreeMap<Long, String> GetLongStringMap(ListTag tagList) {
        TreeMap<Long, String> list = new TreeMap<Long, String>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            list.put(nbttagcompound.getLong("Long"), nbttagcompound.getString("String"));
        }
        return list;
    }

    public static ListTag NBTLongStringMap(Map<Long, String> map) {
        ListTag nbttaglist = new ListTag();
        if (map == null) {
            return nbttaglist;
        }
        for (long slot : map.keySet()) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putLong("Long", slot);
            nbttagcompound.putString("String", map.get(slot));
            nbttaglist.add((Object)nbttagcompound);
        }
        return nbttaglist;
    }
}

