/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.NoppesUtilServer;

public class NoppesUtilPlayer {
    public static boolean compareItems(ItemStack item, ItemStack item2, boolean ignoreDamage, boolean ignoreNBT) {
        if (NoppesUtilServer.IsItemStackNull(item) || NoppesUtilServer.IsItemStackNull(item2)) {
            return false;
        }
        return NoppesUtilPlayer.compareItemDetails(item, item2, ignoreDamage, ignoreNBT);
    }

    private static boolean compareItemDetails(ItemStack item, ItemStack item2, boolean ignoreDamage, boolean ignoreNBT) {
        if (item.getItem() != item2.getItem()) {
            return false;
        }
        if (!ignoreDamage && item.getDamageValue() != -1 && item.getDamageValue() != item2.getDamageValue()) {
            return false;
        }
        if (!(ignoreNBT || item.getComponents().isEmpty() || !item2.getComponents().isEmpty() && item.getComponents().equals((Object)item2.getComponents()))) {
            return false;
        }
        return ignoreNBT || item2.getComponents().isEmpty() || !item.getComponents().isEmpty();
    }

    public static boolean compareItems(Player player, ItemStack item, boolean ignoreDamage, boolean ignoreNBT) {
        int size = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack is = player.getInventory().getItem(i);
            if (NoppesUtilServer.IsItemStackNull(is) || !NoppesUtilPlayer.compareItems(item, is, ignoreDamage, ignoreNBT)) continue;
            size += is.getCount();
        }
        return size >= item.getCount();
    }

    public static void consumeItem(Player player, ItemStack item, boolean ignoreDamage, boolean ignoreNBT) {
        if (NoppesUtilServer.IsItemStackNull(item)) {
            return;
        }
        int size = item.getCount();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack is = player.getInventory().getItem(i);
            if (NoppesUtilServer.IsItemStackNull(is) || !NoppesUtilPlayer.compareItems(item, is, ignoreDamage, ignoreNBT)) continue;
            if (size >= is.getCount()) {
                size -= is.getCount();
                player.getInventory().setItem(i, ItemStack.EMPTY);
                continue;
            }
            is.split(size);
            break;
        }
    }

    public static List<ItemStack> countStacks(Container inv, boolean ignoreDamage, boolean ignoreNBT) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (NoppesUtilServer.IsItemStackNull(item)) continue;
            boolean found = false;
            for (ItemStack is : list) {
                if (!NoppesUtilPlayer.compareItems(item, is, ignoreDamage, ignoreNBT)) continue;
                is.setCount(is.getCount() + item.getCount());
                found = true;
                break;
            }
            if (found) continue;
            list.add(item.copy());
        }
        return list;
    }
}

