/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.ForgeEventHandler;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.IDamageSource;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.event.ItemEvent;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.item.IItemScripted;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.items.ItemNbtBook;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketItemUpdate;
import noppes.npcs.shared.common.util.LogWriter;

public class ScriptPlayerEventHandler {
    @SubscribeEvent
    public void onServerTick(PlayerTickEvent.Pre event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        PlayerData data = PlayerData.get(player);
        if (player.tickCount % 10 == 0) {
            EventHooks.onPlayerTick(data.scriptData);
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack item = player.getInventory().getItem(i);
                if (item.isEmpty() || item.getItem() != CustomItems.scripted_item) continue;
                ItemScriptedWrapper isw = (ItemScriptedWrapper)NpcAPI.Instance().getIItemStack(item);
                EventHooks.onScriptItemUpdate(isw, player);
                if (!isw.updateClient) continue;
                isw.updateClient = false;
                Packets.send((ServerPlayer)player, new PacketItemUpdate(i, isw.getMCNbt()));
            }
        }
        if (data.playerLevel != player.experienceLevel) {
            EventHooks.onPlayerLevelUp(data.scriptData, data.playerLevel - player.experienceLevel);
            data.playerLevel = player.experienceLevel;
        }
        data.timers.update();
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntity().level().isClientSide || event.getHand() != InteractionHand.MAIN_HAND || !(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        if (event.getItemStack().getItem() == CustomItems.teleporter) {
            event.setCanceled(true);
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getEntity()).scriptData;
        PlayerEvent.AttackEvent ev = new PlayerEvent.AttackEvent(handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(event.getLevel(), event.getPos()));
        event.setCanceled(EventHooks.onPlayerAttack(handler, ev));
        if (event.getItemStack().getItem() == CustomItems.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.AttackEvent eve = new ItemEvent.AttackEvent((IItemScripted)isw, handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(event.getLevel(), event.getPos()));
            event.setCanceled(EventHooks.onScriptItemAttack(isw, eve));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity().level().isClientSide || event.getHand() != InteractionHand.MAIN_HAND || !(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        if (event.getItemStack().getItem() == CustomItems.nbt_book) {
            ((ItemNbtBook)event.getItemStack().getItem()).blockEvent(event);
            event.setCanceled(true);
            return;
        }
        if (event.getItemStack().getItem() == CustomItems.teleporter) {
            event.setCanceled(true);
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getEntity()).scriptData;
        handler.hadInteract = true;
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(event.getLevel(), event.getPos()));
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
        if (event.getItemStack().getItem() == CustomItems.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(event.getLevel(), event.getPos()));
            event.setCanceled(EventHooks.onScriptItemInteract(isw, eve));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().level().isClientSide || event.getHand() != InteractionHand.MAIN_HAND || !(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        if (event.getItemStack().getItem() == CustomItems.nbt_book) {
            ((ItemNbtBook)event.getItemStack().getItem()).entityEvent(event);
            event.setCanceled(true);
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getEntity()).scriptData;
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 1, NpcAPI.Instance().getIEntity(event.getTarget()));
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
        if (event.getItemStack().getItem() == CustomItems.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 1, NpcAPI.Instance().getIEntity(event.getTarget()));
            event.setCanceled(EventHooks.onScriptItemInteract(isw, eve));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntity().level().isClientSide || event.getHand() != InteractionHand.MAIN_HAND || !(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        if (event.getEntity().isCreative() && event.getEntity().isCrouching() && event.getItemStack().getItem() == CustomItems.scripted_item) {
            NoppesUtilServer.sendOpenGui(event.getEntity(), EnumGuiType.ScriptItem, null);
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getEntity()).scriptData;
        if (handler.hadInteract) {
            handler.hadInteract = false;
            return;
        }
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 0, null);
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
        if (event.getItemStack().getItem() == CustomItems.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 0, null);
            event.setCanceled(EventHooks.onScriptItemInteract(isw, eve));
        }
    }

    @SubscribeEvent
    public void invoke(ArrowLooseEvent event) {
        if (event.getEntity().level().isClientSide || !(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getEntity()).scriptData;
        PlayerEvent.RangedLaunchedEvent ev = new PlayerEvent.RangedLaunchedEvent(handler.getPlayer());
        event.setCanceled(EventHooks.onPlayerRanged(handler, ev));
    }

    @SubscribeEvent
    public void invoke(BlockEvent.BreakEvent event) {
        if (event.getPlayer().level().isClientSide || !(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getPlayer()).scriptData;
        PlayerEvent.BreakEvent ev = new PlayerEvent.BreakEvent(handler.getPlayer(), NpcAPI.Instance().getIBlock((Level)((ServerLevel)event.getLevel()), event.getPos()));
        event.setCanceled(EventHooks.onPlayerBreak(handler, ev));
    }

    @SubscribeEvent
    public void invoke(ItemTossEvent event) {
        if (!(event.getPlayer().level() instanceof ServerLevel)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getPlayer()).scriptData;
        event.setCanceled(EventHooks.onPlayerToss(handler, event.getEntity()));
    }

    @SubscribeEvent
    public void invoke(ItemEntityPickupEvent.Pre event) {
        if (!(event.getPlayer().level() instanceof ServerLevel)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getPlayer()).scriptData;
        EventHooks.onPlayerPickUp(handler, event.getItemEntity());
    }

    @SubscribeEvent
    public void invoke(PlayerContainerEvent.Open event) {
        if (!(event.getEntity().level() instanceof ServerLevel)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getEntity()).scriptData;
        EventHooks.onPlayerContainerOpen(handler, event.getContainer());
    }

    @SubscribeEvent
    public void invoke(PlayerContainerEvent.Close event) {
        if (!(event.getEntity().level() instanceof ServerLevel)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getEntity()).scriptData;
        EventHooks.onPlayerContainerClose(handler, event.getContainer());
    }

    @SubscribeEvent
    public void invoke(LivingDeathEvent event) {
        PlayerScriptData handler;
        if (!(event.getEntity().level() instanceof ServerLevel)) {
            return;
        }
        Entity source = NoppesUtilServer.GetDamageSourcee(event.getSource());
        if (event.getEntity() instanceof Player) {
            handler = PlayerData.get((Player)((Player)event.getEntity())).scriptData;
            EventHooks.onPlayerDeath(handler, event.getSource(), source);
        }
        if (source instanceof Player) {
            handler = PlayerData.get((Player)((Player)source)).scriptData;
            EventHooks.onPlayerKills(handler, event.getEntity());
        }
    }

    @SubscribeEvent
    public void invoke(LivingDamageEvent.Pre event) {
        PlayerEvent pevent;
        PlayerScriptData handler;
        if (!(event.getEntity().level() instanceof ServerLevel)) {
            return;
        }
        Entity source = NoppesUtilServer.GetDamageSourcee(event.getSource());
        if (event.getEntity() instanceof Player) {
            handler = PlayerData.get((Player)((Player)event.getEntity())).scriptData;
            pevent = new PlayerEvent.DamagedEvent(handler.getPlayer(), source, event.getNewDamage(), event.getSource());
            EventHooks.onPlayerDamaged(handler, pevent);
            event.setNewDamage(pevent.damage);
        }
        if (source instanceof Player) {
            handler = PlayerData.get((Player)((Player)source)).scriptData;
            pevent = new PlayerEvent.DamagedEntityEvent(handler.getPlayer(), (Entity)event.getEntity(), event.getNewDamage(), event.getSource());
            EventHooks.onPlayerDamagedEntity(handler, (PlayerEvent.DamagedEntityEvent)pevent);
            event.setNewDamage(((PlayerEvent.DamagedEntityEvent)pevent).damage);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void invoke(AttackEntityEvent event) {
        if (!(event.getEntity().level() instanceof ServerLevel)) {
            return;
        }
        Player source = event.getEntity();
        if (source instanceof Player) {
            PlayerScriptData handler = PlayerData.get((Player)source).scriptData;
            ItemStack item = source.getMainHandItem();
            IEntity target = NpcAPI.Instance().getIEntity((Entity)event.getEntity());
            IDamageSource damageSource = NpcAPI.Instance().getIDamageSource(event.getEntity().damageSources().playerAttack(event.getEntity()));
            PlayerEvent.AttackEvent ev = new PlayerEvent.AttackEvent(handler.getPlayer(), target, damageSource);
            event.setCanceled(EventHooks.onPlayerAttack(handler, ev));
            if (item.getItem() == CustomItems.scripted_item && !event.isCanceled()) {
                ItemScriptedWrapper isw = ItemScripted.GetWrapper(item);
                ItemEvent.AttackEvent eve = new ItemEvent.AttackEvent((IItemScripted)isw, handler.getPlayer(), target, damageSource);
                event.setCanceled(EventHooks.onScriptItemAttack(isw, eve));
            }
        }
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity().level() instanceof ServerLevel)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getEntity()).scriptData;
        EventHooks.onPlayerLogin(handler);
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!(event.getEntity().level() instanceof ServerLevel)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getEntity()).scriptData;
        EventHooks.onPlayerLogout(handler);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void invoke(ServerChatEvent event) {
        if (!(event.getPlayer().level() instanceof ServerLevel)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((Player)event.getPlayer()).scriptData;
        String message = event.getMessage().getString();
        PlayerEvent.ChatEvent ev = new PlayerEvent.ChatEvent(handler.getPlayer(), event.getMessage().getString());
        EventHooks.onPlayerChat(handler, ev);
        if (!message.equals(ev.message)) {
            MutableComponent chat = Component.translatable((String)"");
            chat.append(ev.message);
            event.setMessage((Component)chat);
        }
    }

    private Set<Class> getClasses(String packageName) {
        packageName = packageName.replace('.', '/');
        HashSet<String> urls = new HashSet<String>();
        try {
            Module module = EntityEvent.class.getModule();
            Enumeration<URL> resources = module.getClassLoader().getResources(packageName);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                String path = url.getPath();
                int i = path.indexOf(".jar");
                if (i <= 0) continue;
                urls.add(path.substring(0, i + 4));
            }
        }
        catch (Throwable module) {
            // empty catch block
        }
        try {
            Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources(packageName);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                String path = url.getPath();
                int i = path.indexOf(".jar");
                if (i <= 0) continue;
                urls.add(path.substring(0, i + 4));
            }
        }
        catch (Throwable resources) {
            // empty catch block
        }
        HashSet<Class> classes = new HashSet<Class>();
        for (String path : urls) {
            try {
                JarFile file = new JarFile(new File(path));
                Enumeration<JarEntry> entries = file.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !entry.getName().startsWith(packageName)) continue;
                    String name = entry.getName().replace('/', '.');
                    try {
                        Class<?> c = Class.forName(name.substring(0, name.length() - 6));
                        if (Event.class.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers()) && Modifier.isPublic(c.getModifiers())) {
                            if (c.getDeclaredClasses().length > 0) {
                                classes.addAll(Arrays.asList(c.getDeclaredClasses()));
                            } else {
                                classes.add(c);
                            }
                        }
                        classes.add(c);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
            }
        }
        return classes;
    }

    public ScriptPlayerEventHandler registerForgeEvents() {
        block8: {
            ForgeEventHandler.eventNames.clear();
            ForgeEventHandler handler = new ForgeEventHandler();
            try {
                Method m = handler.getClass().getMethod("forgeEntity", Event.class);
                Method register = NeoForge.EVENT_BUS.getClass().getDeclaredMethod("register", Class.class, Object.class, Method.class);
                register.setAccessible(true);
                for (Class c : this.getClasses("net.neoforged.neoforge.event.")) {
                    try {
                        String eventName;
                        if (EntityEvent.EntityConstructing.class.isAssignableFrom(c) || LevelEvent.CreateSpawnPosition.class.isAssignableFrom(c) || ClientTickEvent.class.isAssignableFrom(c) || ItemTooltipEvent.class.isAssignableFrom(c) || ForgeEventHandler.eventNames.contains(eventName = ForgeEventHandler.getEventName(c))) continue;
                        register.invoke((Object)NeoForge.EVENT_BUS, c, handler, m);
                        ForgeEventHandler.eventNames.add(eventName);
                    }
                    catch (Throwable throwable) {}
                }
                if (!PixelmonHelper.Enabled) break block8;
                try {
                    for (Class c : this.getClasses("com.pixelmonmod.pixelmon.api.events.")) {
                        ForgeEventHandler.eventNames.add(ForgeEventHandler.getEventName(c));
                        register.invoke((Object)PixelmonHelper.EVENT_BUS, c, handler, m);
                    }
                }
                catch (Throwable e) {
                    LogWriter.except(e);
                }
            }
            catch (Throwable e) {
                LogWriter.except(e);
            }
        }
        return this;
    }
}

