/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIFollow
extends Goal {
    private EntityNPCInterface npc;
    private LivingEntity owner;
    public int updateTick = 0;

    public EntityAIFollow(EntityNPCInterface npc) {
        this.npc = npc;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.canExcute()) {
            return false;
        }
        return !this.npc.isInRange((Entity)this.owner, this.npc.followRange());
    }

    public boolean canExcute() {
        return this.npc.isAlive() && this.npc.isFollower() && !this.npc.isAttacking() && (this.owner = this.npc.getOwner()) != null && this.npc.ais.animationType != 1;
    }

    public void start() {
        this.updateTick = 10;
    }

    public boolean canContinueToUse() {
        return !this.npc.getNavigation().isDone() && !this.npc.isInRange((Entity)this.owner, 2.0) && this.canExcute();
    }

    public void stop() {
        this.owner = null;
        this.npc.getNavigation().stop();
    }

    public void tick() {
        ++this.updateTick;
        if (this.updateTick < 10) {
            return;
        }
        this.updateTick = 0;
        this.npc.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.npc.getMaxHeadXRot());
        double distance = this.npc.distanceToSqr((Entity)this.owner);
        double speed = 1.0 + distance / 150.0;
        if (speed > 3.0) {
            speed = 3.0;
        }
        if (this.owner.isSprinting()) {
            speed += 0.5;
        }
        if (this.npc.getNavigation().moveTo((Entity)this.owner, speed) || this.npc.isInRange((Entity)this.owner, 16.0)) {
            return;
        }
        this.npc.tpTo(this.owner);
    }
}

