/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAILook
extends Goal {
    private final EntityNPCInterface npc;
    private int idle = 0;
    private double lookX;
    private double lookZ;
    private boolean forced = false;
    private Entity forcedEntity = null;

    public EntityAILook(EntityNPCInterface npc) {
        this.npc = npc;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.forced) {
            return true;
        }
        if (this.npc.isAttacking() || !this.npc.getNavigation().isDone() || this.npc.isSleeping() || !this.npc.isAlive()) {
            return false;
        }
        if (this.npc.isInteracting() || this.npc.ais.getStandingType() > 0 || this.idle > 0) {
            return true;
        }
        return this.npc.getRandom().nextFloat() < 0.004f;
    }

    public void start() {
        if (this.npc.ais.getStandingType() == 0 || this.npc.ais.getStandingType() == 3) {
            double var1 = Math.PI * 2 * this.npc.getRandom().nextDouble();
            if (this.npc.ais.getStandingType() == 3) {
                var1 = Math.PI / 180 * (double)this.npc.ais.orientation + 0.6283185307179586 + 1.8849555921538759 * this.npc.getRandom().nextDouble();
            }
            this.lookX = Math.cos(var1);
            this.lookZ = Math.sin(var1);
            this.idle = 20 + this.npc.getRandom().nextInt(20);
        }
    }

    public void rotate(Entity entity) {
        this.forced = true;
        this.forcedEntity = entity;
    }

    public void rotate(int degrees) {
        this.forced = true;
        this.npc.yHeadRot = this.npc.yBodyRot = (float)degrees;
        this.npc.setYRot(degrees);
    }

    public void stop() {
        this.forced = false;
        this.forcedEntity = null;
    }

    public void tick() {
        Entity lookat = null;
        if (this.forced && this.forcedEntity != null) {
            lookat = this.forcedEntity;
        } else if (this.npc.isInteracting()) {
            Iterator<LivingEntity> ita = this.npc.interactingEntities.iterator();
            double closestDistance = 12.0;
            while (ita.hasNext()) {
                LivingEntity entity = ita.next();
                double distance = entity.distanceToSqr((Entity)this.npc);
                if (distance < closestDistance) {
                    closestDistance = entity.distanceToSqr((Entity)this.npc);
                    lookat = entity;
                    continue;
                }
                if (!(distance > 12.0)) continue;
                ita.remove();
            }
        } else if (this.npc.ais.getStandingType() == 2) {
            lookat = this.npc.level().getNearestPlayer((Entity)this.npc, 16.0);
        }
        if (lookat != null) {
            this.npc.getLookControl().setLookAt(lookat, 10.0f, (float)this.npc.getMaxHeadXRot());
            return;
        }
        if (this.idle > 0) {
            --this.idle;
            this.npc.getLookControl().setLookAt(this.npc.getX() + this.lookX, this.npc.getY() + (double)this.npc.getEyeHeight(), this.npc.getZ() + this.lookZ, 10.0f, (float)this.npc.getMaxHeadXRot());
        }
        if (this.npc.ais.getStandingType() == 1 && !this.forced) {
            this.npc.yHeadRot = this.npc.yBodyRot = (float)this.npc.ais.orientation;
            this.npc.setYRot(this.npc.ais.orientation);
        }
    }
}

