/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileRedstoneBlock;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.packets.server.SPacketGuiOpen;

public class BlockNpcRedstone
extends BlockInterface {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final MapCodec<BlockNpcRedstone> CODEC = BlockNpcRedstone.simpleCodec(BlockNpcRedstone::new);

    public BlockNpcRedstone() {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.STONE).lightLevel(state -> 12).strength(50.0f, 2000.0f));
    }

    public BlockNpcRedstone(BlockBehaviour.Properties p_49696_) {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.STONE).lightLevel(state -> 12).strength(50.0f, 2000.0f));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (stack != null && stack.getItem() == CustomItems.wand && CustomNpcsPermissions.hasPermission((ServerPlayer)player, CustomNpcsPermissions.EDIT_BLOCKS)) {
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.RedstoneBlock, null, pos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public void onPlace(BlockState state, Level par1Level, BlockPos pos, BlockState stateNew, boolean bo) {
        par1Level.updateNeighborsAt(pos, (Block)this);
        par1Level.updateNeighborsAt(pos.below(), (Block)this);
        par1Level.updateNeighborsAt(pos.above(), (Block)this);
        par1Level.updateNeighborsAt(pos.west(), (Block)this);
        par1Level.updateNeighborsAt(pos.east(), (Block)this);
        par1Level.updateNeighborsAt(pos.south(), (Block)this);
        par1Level.updateNeighborsAt(pos.north(), (Block)this);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack item) {
        if (!level.isClientSide && entity instanceof Player) {
            SPacketGuiOpen.sendOpenGui((Player)entity, EnumGuiType.RedstoneBlock, null, pos);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        this.onPlace(state, level, pos, state, isMoving);
    }

    public int getSignal(BlockState state, BlockGetter worldIn, BlockPos pos, Direction side) {
        return this.isActivated(state);
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.isActivated(state);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    public int isActivated(BlockState state) {
        return (Boolean)state.getValue((Property)ACTIVE) != false ? 15 : 0;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileRedstoneBlock(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockNpcRedstone.createTickerHelper(type, CustomBlocks.tile_redstoneblock, TileRedstoneBlock::tick);
    }
}

