/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.packets.server.SPacketGuiOpen;
import org.jetbrains.annotations.Nullable;

public class BlockScripted
extends BlockInterface {
    public static final VoxelShape AABB = Shapes.create((AABB)new AABB((double)0.001f, (double)0.001f, (double)0.001f, (double)0.998f, (double)0.998f, (double)0.998f));
    public static final MapCodec<BlockScripted> CODEC = BlockScripted.simpleCodec(BlockScripted::new);

    public BlockScripted() {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.STONE).sound(SoundType.STONE).strength(5.0f, 10.0f));
    }

    public BlockScripted(BlockBehaviour.Properties p_49696_) {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.STONE).sound(SoundType.STONE).strength(5.0f, 10.0f));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileScripted(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        TileScripted tile = (TileScripted)level.getBlockEntity(pos);
        if (tile != null && tile.isPassible) {
            return Shapes.empty();
        }
        return AABB;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (stack != null && (stack.getItem() == CustomItems.wand || stack.getItem() == CustomItems.scripter)) {
            PlayerData data = PlayerData.get(player);
            data.scriptBlockPos = pos;
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.ScriptBlock, null, pos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Vec3 vec = hitResult.getLocation();
        float x = (float)(vec.x - (double)pos.getX());
        float y = (float)(vec.y - (double)pos.getY());
        float z = (float)(vec.z - (double)pos.getZ());
        TileScripted tile = (TileScripted)level.getBlockEntity(pos);
        return EventHooks.onScriptBlockInteract(tile, player, hitResult.getDirection().get3DDataValue(), x, y, z) ? InteractionResult.FAIL : InteractionResult.SUCCESS;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack item) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            PlayerData data = PlayerData.get(player);
            data.scriptBlockPos = pos;
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.ScriptBlock, null, pos);
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        if (level.isClientSide) {
            return;
        }
        TileScripted tile = (TileScripted)level.getBlockEntity(pos);
        EventHooks.onScriptBlockCollide(tile, entityIn);
    }

    public void handlePrecipitation(BlockState state, Level level, BlockPos pos, Biome.Precipitation type) {
        if (level.isClientSide || type != Biome.Precipitation.RAIN) {
            return;
        }
        TileScripted tile = (TileScripted)level.getBlockEntity(pos);
        EventHooks.onScriptBlockRainFill(tile);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (level.isClientSide) {
            return;
        }
        TileScripted tile = (TileScripted)level.getBlockEntity(pos);
        fallDistance = EventHooks.onScriptBlockFallenUpon(tile, entity, fallDistance);
        super.fallOn(level, state, pos, entity, fallDistance);
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (level.isClientSide) {
            return;
        }
        TileScripted tile = (TileScripted)level.getBlockEntity(pos);
        EventHooks.onScriptBlockClicked(tile, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.isClientSide) {
            TileScripted tile = (TileScripted)level.getBlockEntity(pos);
            EventHooks.onScriptBlockBreak(tile);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        TileScripted tile;
        if (!level.isClientSide && !EventHooks.onScriptBlockHarvest(tile = (TileScripted)level.getBlockEntity(pos), player)) {
            super.playerDestroy(level, player, pos, state, blockEntity, tool);
        }
    }

    public List<ItemStack> getDrops(BlockState p_287732_, LootParams.Builder p_287596_) {
        return Collections.emptyList();
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        TileScripted tile;
        if (!level.isClientSide && EventHooks.onScriptBlockExploded(tile = (TileScripted)level.getBlockEntity(pos))) {
            return;
        }
        super.wasExploded(level, pos, explosion);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos pos2, boolean isMoving) {
        if (level.isClientSide) {
            return;
        }
        TileScripted tile = (TileScripted)level.getBlockEntity(pos);
        EventHooks.onScriptBlockNeighborChanged(tile, pos2);
        int power = 0;
        for (Direction enumfacing : Direction.values()) {
            int p = level.getSignal(pos.relative(enumfacing), enumfacing);
            if (p <= power) continue;
            power = p;
        }
        if (tile.prevPower != power && tile.powering <= 0) {
            tile.newPower = power;
        }
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter worldIn, BlockPos pos, Direction side) {
        return this.getDirectSignal(state, worldIn, pos, side);
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        TileScripted tile = (TileScripted)level.getBlockEntity(pos);
        if (tile != null) {
            return tile.activePowering;
        }
        return 0;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return super.propagatesSkylightDown(state, level, pos);
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        TileScripted tile = (TileScripted)level.getBlockEntity(pos);
        if (tile == null) {
            return 0;
        }
        return tile.lightValue;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        TileScripted tile = (TileScripted)level.getBlockEntity(pos);
        float f = -1.0f;
        if (tile != null) {
            f = tile.blockHardness;
        }
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = player.hasCorrectToolForDrops(state) ? 30 : 100;
        return player.getDestroySpeed(state) / f / (float)i;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockScripted.createTickerHelper(type, CustomBlocks.tile_scripted, TileScripted::tick);
    }
}

