/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import noppes.npcs.CustomBlocks;
import noppes.npcs.blocks.BlockBorder;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.controllers.data.Availability;

public class TileBorder
extends TileNpcEntity
implements com.google.common.base.Predicate {
    public Availability availability = new Availability();
    public AABB boundingbox;
    public int rotation = 0;
    public int height = 10;
    public String message = "availability.areaNotAvailble";

    public TileBorder(BlockPos pos, BlockState state) {
        super(CustomBlocks.tile_border, pos, state);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.readExtraNBT(compound);
        if (this.getLevel() != null) {
            this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)CustomBlocks.border.defaultBlockState().setValue((Property)BlockBorder.ROTATION, (Comparable)Integer.valueOf(this.rotation)));
        }
    }

    public void readExtraNBT(CompoundTag compound) {
        this.availability.load((HolderLookup.Provider)this.level.registryAccess(), compound.getCompound("BorderAvailability"));
        this.rotation = compound.getInt("BorderRotation");
        this.height = compound.getInt("BorderHeight");
        this.message = compound.getString("BorderMessage");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.writeExtraNBT(tag);
        super.saveAdditional(tag, registries);
    }

    public void writeExtraNBT(CompoundTag compound) {
        compound.put("BorderAvailability", (Tag)this.availability.save((HolderLookup.Provider)this.level.registryAccess(), new CompoundTag()));
        compound.putInt("BorderRotation", this.rotation);
        compound.putInt("BorderHeight", this.height);
        compound.putString("BorderMessage", this.message);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TileBorder tile) {
        if (level.isClientSide) {
            return;
        }
        AABB box = new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + tile.height + 1), (double)(pos.getZ() + 1));
        List list = level.getEntitiesOfClass(Entity.class, box, (Predicate)((Object)tile));
        for (Entity entity : list) {
            if (entity instanceof ThrownEnderpearl) {
                ThrownEnderpearl pearl = (ThrownEnderpearl)entity;
                if (!(pearl.getOwner() instanceof Player) || tile.availability.isAvailable((Player)pearl.getOwner())) continue;
                entity.setRemoved(Entity.RemovalReason.DISCARDED);
                continue;
            }
            Player player = (Player)entity;
            if (tile.availability.isAvailable(player)) continue;
            BlockPos pos2 = new BlockPos((Vec3i)tile.worldPosition);
            if (tile.rotation == 2) {
                pos2 = pos2.south();
            } else if (tile.rotation == 0) {
                pos2 = pos2.north();
            } else if (tile.rotation == 1) {
                pos2 = pos2.east();
            } else if (tile.rotation == 3) {
                pos2 = pos2.west();
            }
            while (!level.isEmptyBlock(pos2)) {
                pos2 = pos2.above();
            }
            player.teleportTo((double)pos2.getX() + 0.5, (double)pos2.getY(), (double)pos2.getZ() + 0.5);
            if (tile.message.isEmpty()) continue;
            player.displayClientMessage((Component)Component.translatable((String)tile.message), true);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag compound = new CompoundTag();
        compound.putInt("x", this.worldPosition.getX());
        compound.putInt("y", this.worldPosition.getY());
        compound.putInt("z", this.worldPosition.getZ());
        compound.putInt("Rotation", this.rotation);
        return compound;
    }

    public boolean isEntityApplicable(Entity var1) {
        return var1 instanceof ServerPlayer || var1 instanceof ThrownEnderpearl;
    }

    public boolean apply(Object ob) {
        return this.isEntityApplicable((Entity)ob);
    }
}

