/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import noppes.npcs.CustomBlocks;
import noppes.npcs.blocks.tiles.TileNpcEntity;

public class TileDoor
extends TileNpcEntity {
    public int tickCount = 0;
    public Block blockModel = CustomBlocks.scripted_door;
    public boolean needsClientUpdate = false;

    public TileDoor(BlockEntityType<?> p_i48289_1_, BlockPos pos, BlockState state) {
        super(p_i48289_1_, pos, state);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.setDoorNBT(compound);
    }

    public void setDoorNBT(CompoundTag compound) {
        this.blockModel = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)compound.getString("ScriptDoorBlockModel")));
        if (this.blockModel == null || !(this.blockModel instanceof DoorBlock)) {
            this.blockModel = CustomBlocks.scripted_door;
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.getDoorNBT(tag);
        super.saveAdditional(tag, registries);
    }

    public CompoundTag getDoorNBT(CompoundTag compound) {
        compound.putString("ScriptDoorBlockModel", String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)this.blockModel)));
        return compound;
    }

    public void setItemModel(Block block) {
        if (block == null || !(block instanceof DoorBlock)) {
            block = CustomBlocks.scripted_door;
        }
        if (this.blockModel == block) {
            return;
        }
        this.blockModel = block;
        this.needsClientUpdate = true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TileDoor tile) {
        ++tile.tickCount;
        if (tile.tickCount >= 10) {
            tile.tickCount = 0;
            if (tile.needsClientUpdate) {
                tile.setChanged();
                level.setBlockAndUpdate(pos, state);
                tile.needsClientUpdate = false;
            }
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag compound = new CompoundTag();
        compound.putInt("x", this.worldPosition.getX());
        compound.putInt("y", this.worldPosition.getY());
        compound.putInt("z", this.worldPosition.getZ());
        this.getDoorNBT(compound);
        return compound;
    }
}

