/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import noppes.npcs.client.gui.select.GuiTextureSelection;
import noppes.npcs.client.parts.MpmPartReader;
import noppes.npcs.shared.client.util.TextureCache;

public class CustomNpcResourceListener
implements ResourceManagerReloadListener {
    public static int DefaultTextColor = 0x404040;

    public void onResourceManagerReload(ResourceManager manager) {
        try {
            DefaultTextColor = Integer.parseInt(I18n.get((String)"customnpcs.defaultTextColor", (Object[])new Object[0]), 16);
        }
        catch (NumberFormatException e) {
            DefaultTextColor = 0x404040;
        }
        GuiTextureSelection.clear();
        MpmPartReader.reload();
    }

    private void createTextureCache() {
        this.enlargeTexture("acacia_planks");
        this.enlargeTexture("birch_planks");
        this.enlargeTexture("crimson_planks");
        this.enlargeTexture("dark_oak_planks");
        this.enlargeTexture("jungle_planks");
        this.enlargeTexture("oak_planks");
        this.enlargeTexture("spruce_planks");
        this.enlargeTexture("warped_planks");
        this.enlargeTexture("iron_block");
        this.enlargeTexture("diamond_block");
        this.enlargeTexture("stone");
        this.enlargeTexture("gold_block");
        this.enlargeTexture("white_wool");
    }

    private void enlargeTexture(String texture) {
        ResourceLocation location;
        TextureManager manager = Minecraft.getInstance().getTextureManager();
        Object ob = manager.getTexture(location = ResourceLocation.tryParse((String)("customnpcs:textures/cache/" + texture + ".png")));
        if (!(ob instanceof TextureCache)) {
            ob = new TextureCache(location, ResourceLocation.tryParse((String)("textures/block/" + texture + ".png")));
            manager.register(location, ob);
        }
    }
}

