/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import noppes.npcs.client.ISynchedEntityData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.EntityIMixin;
import noppes.npcs.mixin.EntityLivingIMixin;
import noppes.npcs.mixin.WalkAnimationStateMixin;
import noppes.npcs.shared.common.util.LogWriter;

public class EntityUtil {
    private static HashMap<EntityType<? extends Entity>, Class> entityClasses = new HashMap();

    public static void Copy(LivingEntity copied, LivingEntity entity) {
        EntityNPCInterface npc;
        ((EntityIMixin)entity).setLevel(copied.level());
        entity.deathTime = copied.deathTime;
        entity.walkDist = copied.walkDist;
        entity.walkDistO = copied.walkDist;
        entity.moveDist = copied.moveDist;
        entity.zza = copied.zza;
        entity.xxa = copied.xxa;
        entity.setOnGround(copied.onGround());
        entity.fallDistance = copied.fallDistance;
        entity.setJumping(((EntityLivingIMixin)copied).jumping());
        List<SynchedEntityData.DataItem<?>> copiedData = ((ISynchedEntityData)copied.getEntityData()).getAll();
        List<SynchedEntityData.DataItem<?>> data = ((ISynchedEntityData)entity.getEntityData()).getAll();
        for (SynchedEntityData.DataItem<?> entry : copiedData) {
            if (!data.stream().anyMatch(e -> e.getAccessor() == entry.getAccessor()) || !(entry.getValue() instanceof SynchedEntityData.DataValue)) continue;
            entity.getEntityData().set(entry.getAccessor(), ((SynchedEntityData.DataValue)entry.getValue()).value());
        }
        entity.xo = copied.xo;
        entity.yo = copied.yo;
        entity.zo = copied.zo;
        entity.setPos(copied.getX(), copied.getY(), copied.getZ());
        entity.xOld = copied.xOld;
        entity.yOld = copied.yOld;
        entity.zOld = copied.zOld;
        entity.setDeltaMovement(copied.getDeltaMovement());
        entity.setXRot(copied.getXRot());
        entity.setYRot(copied.getYRot());
        entity.xRotO = copied.xRotO;
        entity.yRotO = copied.yRotO;
        entity.yHeadRot = copied.yHeadRot;
        entity.yHeadRotO = copied.yHeadRotO;
        entity.yBodyRot = copied.yBodyRot;
        entity.yBodyRotO = copied.yBodyRotO;
        ((EntityLivingIMixin)entity).useItemRemaining(copied.getUseItemRemainingTicks());
        ((WalkAnimationStateMixin)entity.walkAnimation).setPosition(copied.walkAnimation.position());
        ((EntityLivingIMixin)entity).animStep(((EntityLivingIMixin)copied).animStep());
        ((EntityLivingIMixin)entity).animStepO(((EntityLivingIMixin)copied).animStepO());
        ((EntityLivingIMixin)entity).swimAmount(((EntityLivingIMixin)copied).swimAmount());
        ((EntityLivingIMixin)entity).swimAmountO(((EntityLivingIMixin)copied).swimAmountO());
        entity.swinging = copied.swinging;
        entity.swingTime = copied.swingTime;
        entity.walkAnimation.setSpeed(copied.walkAnimation.speed());
        ((WalkAnimationStateMixin)entity.walkAnimation).setSpeedOld(((WalkAnimationStateMixin)copied.walkAnimation).getSpeedOld());
        entity.attackAnim = copied.attackAnim;
        entity.oAttackAnim = copied.oAttackAnim;
        entity.tickCount = copied.tickCount;
        entity.setHealth(Math.min(copied.getHealth(), entity.getMaxHealth()));
        entity.hurtTime = copied.hurtTime;
        entity.deathTime = copied.deathTime;
        if (entity instanceof Player && copied instanceof Player) {
            EquipmentSlot[] ePlayer = (EquipmentSlot[])entity;
            Player cPlayer = (Player)copied;
            ePlayer.bob = cPlayer.bob;
            ePlayer.oBob = cPlayer.oBob;
            ePlayer.xCloakO = cPlayer.xCloakO;
            ePlayer.yCloakO = cPlayer.yCloakO;
            ePlayer.zCloakO = cPlayer.zCloakO;
            ePlayer.xCloak = cPlayer.xCloak;
            ePlayer.yCloak = cPlayer.yCloak;
            ePlayer.zCloak = cPlayer.zCloak;
        }
        for (Player player : EquipmentSlot.values()) {
            entity.setItemSlot((EquipmentSlot)player, copied.getItemBySlot((EquipmentSlot)player));
        }
        if (entity instanceof EnderDragon) {
            entity.setXRot(entity.getXRot() + 180.0f);
        }
        ((EntityIMixin)entity).removal(((EntityIMixin)copied).removal());
        entity.deathTime = copied.deathTime;
        entity.tickCount = copied.tickCount;
        if (entity instanceof EnderDragon) {
            entity.setYRot(entity.getYRot() + 180.0f);
        }
        if (entity instanceof Chicken) {
            ((Chicken)entity).flap = copied.onGround() ? 0.0f : 1.0f;
        }
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            entity.setItemSlot(equipmentSlot, copied.getItemBySlot(equipmentSlot));
        }
        if (copied instanceof EntityNPCInterface && entity instanceof EntityNPCInterface) {
            npc = (EntityNPCInterface)copied;
            EntityNPCInterface target = (EntityNPCInterface)entity;
            target.textureLocation = npc.textureLocation;
            target.textureGlowLocation = npc.textureGlowLocation;
            target.textureCloakLocation = npc.textureCloakLocation;
            target.display = npc.display;
            target.inventory = npc.inventory;
            if (npc.job.getType() == 9) {
                target.job = npc.job;
            }
            if (target.currentAnimation != npc.currentAnimation) {
                target.currentAnimation = npc.currentAnimation;
                npc.refreshDimensions();
            }
            target.setDataWatcher(npc.getEntityData());
        }
        if (entity instanceof EntityCustomNpc && copied instanceof EntityCustomNpc) {
            npc = (EntityCustomNpc)copied;
            EntityCustomNpc target = (EntityCustomNpc)entity;
            target.modelData = ((EntityCustomNpc)npc).modelData.copy();
            target.modelData.setEntity(null);
        }
    }

    private <T> void setData(LivingEntity entity, List<SynchedEntityData.DataItem<T>> copiedData, List<SynchedEntityData.DataItem<T>> data) {
        for (SynchedEntityData.DataItem entry : copiedData) {
            if (!data.stream().anyMatch(e -> e.getAccessor() == entry.getAccessor())) continue;
            entity.getEntityData().set(entry.getAccessor(), entry.getValue());
        }
    }

    public static void setRecentlyHit(LivingEntity entity) {
        ((EntityLivingIMixin)entity).lastHurtByPlayerTime(100);
    }

    public static HashMap<EntityType<? extends Entity>, Class> getAllEntitiesClasses(Level level) {
        if (!entityClasses.isEmpty()) {
            return entityClasses;
        }
        HashMap<EntityType<? extends Entity>, Class> data = new HashMap<EntityType<? extends Entity>, Class>();
        for (EntityType ent : BuiltInRegistries.ENTITY_TYPE) {
            try {
                Entity e = ent.create(level);
                if (e == null) continue;
                if (LivingEntity.class.isAssignableFrom(e.getClass())) {
                    data.put((EntityType<? extends Entity>)ent, e.getClass());
                }
                e.discard();
            }
            catch (Exception exception) {}
        }
        entityClasses = data;
        return entityClasses;
    }

    public static HashMap<EntityType<? extends Entity>, Class> getAllEntitiesClassesNoNpcs(Level level) {
        HashMap<EntityType<? extends Entity>, Class> data = new HashMap<EntityType<? extends Entity>, Class>(EntityUtil.getAllEntitiesClasses(level));
        Iterator<Map.Entry<EntityType<? extends Entity>, Class>> ita = data.entrySet().iterator();
        while (ita.hasNext()) {
            Map.Entry<EntityType<? extends Entity>, Class> entry = ita.next();
            if (!EntityNPCInterface.class.isAssignableFrom(entry.getValue()) && LivingEntity.class.isAssignableFrom(entry.getValue())) continue;
            ita.remove();
        }
        return data;
    }

    public static HashMap<String, ResourceLocation> getAllEntities(Level level, boolean withNpcs) {
        HashMap<String, ResourceLocation> data = new HashMap<String, ResourceLocation>();
        for (EntityType ent : BuiltInRegistries.ENTITY_TYPE) {
            try {
                Entity e = ent.create(level);
                if (e == null) continue;
                if (LivingEntity.class.isAssignableFrom(e.getClass()) && (withNpcs || !EntityNPCInterface.class.isAssignableFrom(e.getClass()))) {
                    data.put(ent.getDescriptionId(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)ent));
                }
                e.discard();
            }
            catch (Throwable e) {
                LogWriter.except(e);
            }
        }
        return data;
    }
}

