/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiButtonWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.components.CustomGuiTexturedRect;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketCustomGuiButton;
import org.joml.Matrix4fStack;

public class CustomGuiButton
extends Button
implements IGuiComponent {
    protected GuiCustom parent;
    private CustomGuiTexturedRect background;
    public CustomGuiButtonWrapper component;
    protected boolean hovered;
    private int colour = 0xFFFFFF;
    protected Button.OnPress onPress = button -> {
        if (!component.disablePackets) {
            Packets.sendServer(new SPacketCustomGuiButton(component.getUniqueID()));
        } else {
            component.onPress(parent.guiWrapper);
        }
    };
    public int id;

    public CustomGuiButton(GuiCustom parent, CustomGuiButtonWrapper component) {
        super(component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), (Component)Component.translatable((String)component.getLabel()), btn -> {}, null);
        this.parent = parent;
        this.component = component;
        this.init();
    }

    public void onPress() {
        this.onPress.onPress((Button)this);
    }

    @Override
    public void init() {
        this.id = this.component.getID();
        this.setX(this.component.getPosX());
        this.setY(this.component.getPosY());
        this.setWidth(this.component.getWidth());
        this.height = this.component.getHeight();
        this.background = new CustomGuiTexturedRect(this.parent, this.component.getTextureRect());
        this.setMessage((Component)Component.translatable((String)this.component.getLabel()));
        this.active = this.component.getEnabled() && this.component.getVisible();
        this.visible = this.component.getVisible();
    }

    public boolean keyPressed(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        return false;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void onRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = graphics.pose();
        if (!this.visible) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate((float)this.getX(), (float)this.getY(), 0.0f);
        Minecraft mc = Minecraft.getInstance();
        this.hovered = this.isHovered(mouseX, mouseY);
        int i = 0;
        i = this.component.getTexture().equals("textures/gui/widgets.png") ? (!this.active ? 0 : (this.hovered ? 2 : 1)) : (this.hovered ? 1 : 0);
        this.background.textureY = this.component.getTextureY() + i * this.component.getTextureHoverOffset();
        this.background.onRender(graphics, mouseX - this.getX(), mouseY - this.getY(), partialTicks);
        this.renderLabel(graphics);
        if (!this.component.getDisplayItem().isEmpty()) {
            int xx = (int)(((float)this.width - 16.0f) / 2.0f);
            int yy = (int)(((float)this.height - 16.0f) / 2.0f) + 1;
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, -90.0f);
            Matrix4fStack posestack = RenderSystem.getModelViewStack();
            posestack.pushMatrix();
            posestack.translate((float)this.getX(), (float)this.getY(), -90.0f);
            RenderSystem.applyModelViewMatrix();
            graphics.renderItem(this.component.getDisplayItem().getMCItemStack(), xx, yy);
            graphics.renderItemDecorations(mc.font, this.component.getDisplayItem().getMCItemStack(), xx, yy);
            posestack.popMatrix();
            graphics.pose().popPose();
            RenderSystem.applyModelViewMatrix();
        }
        if (this.hovered && this.component.hasHoverText()) {
            this.parent.hoverText = this.component.getHoverTextList();
        }
        matrixStack.popPose();
    }

    public void renderLabel(GuiGraphics graphics) {
        if (!this.component.getLabel().isEmpty()) {
            int j = 0xE0E0E0;
            if (this.colour != 0) {
                j = this.colour;
            } else if (!this.active) {
                j = 0xA0A0A0;
            } else if (this.hovered) {
                j = 0xFFFFA0;
            }
            Minecraft mc = Minecraft.getInstance();
            graphics.pose().translate(0.0f, 0.0f, (float)this.id);
            graphics.drawCenteredString(mc.font, this.getMessage(), this.width / 2, (this.height - 8) / 2, j);
        }
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
    }

    @Override
    public ICustomGuiComponent component() {
        return this.component;
    }

    public void setColour(int colour) {
        this.colour = colour;
    }

    protected int hoverState(boolean mouseOver) {
        int i = 0;
        if (mouseOver) {
            i = 1;
        }
        return i;
    }
}

