/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;

public class CustomGuiLabel
extends AbstractWidget
implements IGuiComponent {
    private CustomGuiLabelWrapper component;
    private int id;
    private GuiCustom parent;

    public CustomGuiLabel(GuiCustom parent, CustomGuiLabelWrapper component) {
        super(component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), (Component)Component.translatable((String)component.getText()));
        this.component = component;
        this.parent = parent;
        this.init();
    }

    @Override
    public void init() {
        this.id = this.component.getID();
        this.setX(this.component.getPosX());
        this.setY(this.component.getPosY());
        this.setWidth(this.component.getWidth());
        this.height = this.component.getHeight();
        this.active = this.component.getEnabled() && this.component.getVisible();
        this.visible = this.component.getVisible();
        this.setMessage((Component)Component.translatable((String)this.component.getText()));
    }

    @Override
    public void onRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean hovered;
        PoseStack matrixStack = graphics.pose();
        if (!this.active) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, (float)this.id);
        matrixStack.scale(this.component.getScale(), this.component.getScale(), 0.0f);
        boolean bl = hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        if (this.component.getCentered()) {
            graphics.drawString(Minecraft.getInstance().font, this.getMessage(), (int)(((float)this.getX() + (float)(this.width - Minecraft.getInstance().font.width((FormattedText)this.getMessage())) / 2.0f) / this.component.getScale()), (int)((float)this.getY() / this.component.getScale()), this.component.getColor());
        } else {
            graphics.drawString(Minecraft.getInstance().font, this.getMessage(), (int)((float)this.getX() / this.component.getScale()), (int)((float)this.getY() / this.component.getScale()), this.component.getColor());
        }
        if (hovered && this.component.hasHoverText()) {
            this.parent.hoverText = this.component.getHoverTextList();
        }
        matrixStack.popPose();
    }

    @Override
    public int getID() {
        return this.id;
    }

    public void setText(String s) {
        this.setMessage((Component)Component.translatable((String)s));
    }

    @Override
    public ICustomGuiComponent component() {
        return this.component;
    }

    protected void renderWidget(GuiGraphics p_282139_, int p_268034_, int p_268009_, float p_268085_) {
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public void playDownSound(SoundManager p_93665_) {
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

