/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiTextFieldWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketCustomGuiFocusUpdate;
import noppes.npcs.packets.server.SPacketCustomGuiTextUpdate;

public class CustomGuiTextField
extends EditBox
implements IGuiComponent {
    private static CustomGuiTextField focused = null;
    private GuiCustom parent;
    private CustomGuiTextFieldWrapper component;
    public int id;

    public CustomGuiTextField(GuiCustom parent, CustomGuiTextFieldWrapper component) {
        super(Minecraft.getInstance().font, component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), (Component)Component.translatable((String)component.getText()));
        this.setMaxLength(500);
        this.component = component;
        this.parent = parent;
        this.init();
    }

    @Override
    public void init() {
        this.id = this.component.getID();
        this.setX(this.component.getPosX());
        this.setY(this.component.getPosY());
        this.width = this.component.getWidth();
        this.height = this.component.getHeight();
        this.setTextColor(this.component.getColor());
        if (this.component.getText() != null) {
            this.setValue(this.component.getText());
        }
        this.active = this.component.getEnabled() && this.component.getVisible();
        this.visible = this.component.getVisible();
        this.setFocused(this.component.getFocused());
    }

    @Override
    public ICustomGuiComponent component() {
        return this.component;
    }

    @Override
    public void onRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, (float)this.id);
        boolean hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        this.renderWidget(graphics, mouseX, mouseY, partialTicks);
        if (hovered && this.component.hasHoverText()) {
            this.parent.hoverText = this.component.getHoverTextList();
        }
        matrixStack.popPose();
    }

    @Override
    public int getID() {
        return this.id;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        String text = this.getValue();
        boolean bo = super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        this.component.setText(this.getValue());
        if (!this.getValue().equals(this.component.getText())) {
            this.setValue(this.component.getText());
        }
        if (!text.equals(this.getValue())) {
            if (!this.component.disablePackets) {
                Packets.sendServer(new SPacketCustomGuiTextUpdate(this.component.getUniqueID(), this.getValue()));
            } else {
                this.component.onChange(null);
            }
        }
        return bo;
    }

    public boolean mouseClicked(double i, double j, int k) {
        boolean flag = i >= (double)this.getX() && i < (double)(this.getX() + this.width) && j >= (double)this.getY() && j < (double)(this.getY() + this.height);
        this.setFocused(flag);
        return super.mouseClicked(i, j, k);
    }

    private boolean isValidChar(char c) {
        if (this.component.getCharacterType() == 1) {
            return Character.isDigit(c);
        }
        if (this.component.getCharacterType() == 2) {
            return Character.isDigit(c) || Character.toLowerCase(c) >= 'a' && Character.toLowerCase(c) <= 'f';
        }
        if (this.component.getCharacterType() == 3) {
            return Character.isDigit(c) || c == '.' && !this.getValue().contains(".") || c == '-' && this.getCursorPosition() == 0;
        }
        return true;
    }

    public boolean charTyped(char c, int i) {
        if (!this.isValidChar(c)) {
            return false;
        }
        String text = this.getValue();
        boolean bo = super.charTyped(c, i);
        if (!text.equals(this.getValue())) {
            this.component.setText(this.getValue());
            if (!this.component.disablePackets) {
                Packets.sendServer(new SPacketCustomGuiTextUpdate(this.component.getUniqueID(), this.getValue()));
            } else {
                this.component.onChange(null);
            }
        }
        return bo;
    }

    public void setFocused(boolean bo) {
        if (this.isFocused() == bo) {
            return;
        }
        super.setFocused(bo);
        if (this.component.getFocused() != bo) {
            if (!(this.component.getText().isEmpty() || this.component.getCharacterType() != 1 && this.component.getCharacterType() != 2)) {
                this.component.setInteger(this.component.getInteger());
                this.setValue(this.component.getText());
                if (!this.component.disablePackets) {
                    Packets.sendServer(new SPacketCustomGuiTextUpdate(this.component.getUniqueID(), this.component.getText()));
                }
                this.component.onChange(null);
            }
            this.component.setFocused(bo);
            if (!this.component.disablePackets) {
                Packets.sendServer(new SPacketCustomGuiFocusUpdate(this.component.getUniqueID(), bo));
            } else {
                this.component.onFocusLost(null);
            }
        }
        if (this.isFocused() && focused != this) {
            if (focused != null) {
                focused.setFocused(false);
            }
            focused = this;
        }
        if (!this.isFocused() && focused != this) {
            focused = null;
        }
    }

    public void playDownSound(SoundManager p_93665_) {
    }
}

