/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.containers.ContainerNPCTrader;
import noppes.npcs.roles.RoleTrader;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;

public class GuiNPCTrader
extends GuiContainerNPCInterface<ContainerNPCTrader> {
    private final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/trader.png");
    private final ResourceLocation slot = new ResourceLocation("customnpcs", "textures/gui/slot.png");
    private RoleTrader role;
    private ContainerNPCTrader container;

    public GuiNPCTrader(ContainerNPCTrader container, Inventory inv, Component titleIn) {
        super(NoppesUtil.getLastNpc(), container, inv, titleIn);
        this.container = container;
        this.role = (RoleTrader)this.npc.role;
        this.imageHeight = 224;
        this.imageWidth = 223;
        this.title = "role.trader";
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderBackground(graphics, this.mouseX, this.mouseY, partialTicks);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resource);
        graphics.blit(this.resource, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.slot);
        for (int slot = 0; slot < 18; ++slot) {
            int i = this.guiLeft + slot % 3 * 72 + 10;
            int j = this.guiTop + slot / 3 * 21 + 6;
            ItemStack item = (ItemStack)this.role.inventoryCurrency.items.get(slot);
            ItemStack item2 = (ItemStack)this.role.inventoryCurrency.items.get(slot + 18);
            if (NoppesUtilServer.IsItemStackNull(item)) {
                item = item2;
                item2 = ItemStack.EMPTY;
            }
            if (NoppesUtilPlayer.compareItems(item, item2, false, false)) {
                item = item.copy();
                item.setCount(item.getCount() + item2.getCount());
                item2 = ItemStack.EMPTY;
            }
            ItemStack sold = (ItemStack)this.role.inventorySold.items.get(slot);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.slot);
            graphics.blit(this.slot, i + 42, j, 0, 0, 18, 18);
            if (NoppesUtilServer.IsItemStackNull(item) || NoppesUtilServer.IsItemStackNull(sold)) continue;
            if (!NoppesUtilServer.IsItemStackNull(item2)) {
                graphics.renderItem(item2, i, j + 1);
                graphics.renderItemDecorations(this.font, item2, i, j + 1);
            }
            graphics.renderItem(item, i + 18, j + 1);
            graphics.renderItemDecorations(this.font, item, i + 18, j + 1);
            graphics.drawString(this.font, "=", i + 36, j + 5, CustomNpcResourceListener.DefaultTextColor);
        }
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        for (int slot = 0; slot < 18; ++slot) {
            ItemStack sold;
            int i = slot % 3 * 72 + 10;
            int j = slot / 3 * 21 + 6;
            ItemStack item = (ItemStack)this.role.inventoryCurrency.items.get(slot);
            ItemStack item2 = (ItemStack)this.role.inventoryCurrency.items.get(slot + 18);
            if (NoppesUtilServer.IsItemStackNull(item)) {
                item = item2;
                item2 = ItemStack.EMPTY;
            }
            if (NoppesUtilPlayer.compareItems(item, item2, this.role.ignoreDamage, this.role.ignoreNBT)) {
                item = item.copy();
                item.setCount(item.getCount() + item2.getCount());
                item2 = ItemStack.EMPTY;
            }
            if (NoppesUtilServer.IsItemStackNull(sold = (ItemStack)this.role.inventorySold.items.get(slot))) continue;
            if (this.isHovering(i + 43, j + 1, 16, 16, x, y)) {
                if (!this.container.canBuy(item, item2, (Player)this.player)) {
                    graphics.pose().translate(0.0f, 0.0f, 300.0f);
                    if (!item.isEmpty() && !NoppesUtilPlayer.compareItems((Player)this.player, item, this.role.ignoreDamage, this.role.ignoreNBT)) {
                        graphics.fillGradient(i + 17, j, i + 35, j + 18, 0x70771010, 0x70771010);
                    }
                    if (!item2.isEmpty() && !NoppesUtilPlayer.compareItems((Player)this.player, item2, this.role.ignoreDamage, this.role.ignoreNBT)) {
                        graphics.fillGradient(i - 1, j, i + 17, j + 18, 0x70771010, 0x70771010);
                    }
                    title = I18n.get((String)"trader.insufficient", (Object[])new Object[0]);
                    graphics.drawString(this.font, title, (this.imageWidth - this.font.width(title)) / 2, 131, 0xDD0000);
                    graphics.pose().translate(0.0f, 0.0f, -300.0f);
                } else {
                    title = I18n.get((String)"trader.sufficient", (Object[])new Object[0]);
                    graphics.drawString(this.font, title, (this.imageWidth - this.font.width(title)) / 2, 131, 56576);
                }
            }
            if (this.isHovering(i, j, 16, 16, x, y) && !NoppesUtilServer.IsItemStackNull(item2)) {
                graphics.renderTooltip(this.font, item2, x - this.guiLeft, y - this.guiTop);
            }
            if (!this.isHovering(i + 18, j, 16, 16, x, y)) continue;
            graphics.renderTooltip(this.font, item, x - this.guiLeft, y - this.guiTop);
        }
    }

    @Override
    public void buttonEvent(GuiButtonNop button) {
    }

    @Override
    public void save() {
    }
}

