/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketFollowerHire;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;

public class GuiNpcFollowerHire
extends GuiContainerNPCInterface<ContainerNPCFollowerHire> {
    private final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/followerhire.png");
    private ContainerNPCFollowerHire container;
    private RoleFollower role;

    public GuiNpcFollowerHire(ContainerNPCFollowerHire container, Inventory inv, Component titleIn) {
        super(NoppesUtil.getLastNpc(), container, inv, titleIn);
        this.container = container;
        this.role = (RoleFollower)this.npc.role;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiButtonNop(this, 5, this.guiLeft + 26, this.guiTop + 60, 50, 20, I18n.get((String)"follower.hire", (Object[])new Object[0])));
    }

    @Override
    public void buttonEvent(GuiButtonNop guibutton) {
        if (guibutton.id == 5) {
            Packets.sendServer(new SPacketFollowerHire());
        }
    }

    @Override
    protected void renderLabels(GuiGraphics p_281635_, int p_282681_, int p_283686_) {
        super.renderLabels(p_281635_, p_282681_, p_283686_);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float f, int i, int j) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resource);
        int l = (this.width - this.imageWidth) / 2;
        int i1 = (this.height - this.imageHeight) / 2;
        graphics.blit(this.resource, l, i1, 0, 0, this.imageWidth, this.imageHeight);
        int index = 0;
        for (int slot = 0; slot < this.role.inventory.items.size(); ++slot) {
            ItemStack itemstack = (ItemStack)this.role.inventory.items.get(slot);
            if (NoppesUtilServer.IsItemStackNull(itemstack)) continue;
            int days = 1;
            if (this.role.rates.containsKey(slot)) {
                days = this.role.rates.get(slot);
            }
            int yOffset = index * 26;
            int x = this.guiLeft + 78;
            int y = this.guiTop + yOffset + 10;
            graphics.renderItem(itemstack, x + 11, y);
            graphics.renderItemDecorations(this.font, itemstack, x + 11, y);
            String daysS = days + " " + (days == 1 ? I18n.get((String)"follower.day", (Object[])new Object[0]) : I18n.get((String)"follower.days", (Object[])new Object[0]));
            graphics.drawString(this.font, " = " + daysS, x + 27, y + 4, CustomNpcResourceListener.DefaultTextColor);
            if (this.isHovering(x - this.guiLeft + 11, y - this.guiTop, 16, 16, this.mouseX, this.mouseY)) {
                graphics.renderTooltip(this.font, itemstack, this.mouseX, this.mouseY);
            }
            ++index;
        }
    }

    @Override
    public void save() {
    }
}

