/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.shared.client.model.Model2DRenderer;

public class MarkRenderer {
    public static final ResourceLocation markExclamation = new ResourceLocation("customnpcs", "textures/marks/exclamation.png");
    public static final ResourceLocation markQuestion = new ResourceLocation("customnpcs", "textures/marks/question.png");
    public static final ResourceLocation markPointer = new ResourceLocation("customnpcs", "textures/marks/pointer.png");
    public static final ResourceLocation markCross = new ResourceLocation("customnpcs", "textures/marks/cross.png");
    public static final ResourceLocation markSkull = new ResourceLocation("customnpcs", "textures/marks/skull.png");
    public static final ResourceLocation markStar = new ResourceLocation("customnpcs", "textures/marks/star.png");
    public static int displayList = -1;
    public static Model2DRenderer renderer = new Model2DRenderer(32, 32, 0, 0, 32, 32, markExclamation);

    public static void render(LivingEntity entity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, MarkData.Mark mark) {
        PoseStack matrixStack = poseStack;
        matrixStack.pushPose();
        int color = mark.color;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        ResourceLocation location = markExclamation;
        if (mark.type == 1) {
            location = markQuestion;
        } else if (mark.type == 3) {
            location = markPointer;
        } else if (mark.type == 5) {
            location = markCross;
        } else if (mark.type == 4) {
            location = markSkull;
        } else if (mark.type == 6) {
            location = markStar;
        }
        matrixStack.translate(0.0, (double)entity.getBbHeight() + 0.6, 0.0);
        matrixStack.mulPose(Axis.XN.rotationDegrees(180.0f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(entity.yHeadRot));
        matrixStack.translate(-0.5f, 0.0f, 0.0f);
        renderer.render(location, matrixStack, buffer.getBuffer(RenderType.entityCutout((ResourceLocation)location)), packedLight, OverlayTexture.NO_OVERLAY, red, green, blue, 1.0f);
        matrixStack.popPose();
    }
}

