/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.MatrixStackMixin;
import noppes.npcs.shared.client.util.ImageDownloadAlt;
import noppes.npcs.shared.client.util.ResourceDownloader;
import noppes.npcs.shared.common.util.LogWriter;
import org.joml.Matrix4f;

public class RenderNPCInterface<T extends EntityNPCInterface, M extends EntityModel<T>>
extends LivingEntityRenderer<T, M> {
    public static int LastTextureTick;
    public static EntityNPCInterface currentNpc;

    public RenderNPCInterface(EntityRendererProvider.Context manager, M model, float f) {
        super(manager, model, f);
    }

    public void renderNameTag(T npc, Component text, PoseStack matrixStack, MultiBufferSource buffer, int light, float partialTick) {
        if (npc == null || !this.shouldShowName((LivingEntity)npc) || this.entityRenderDispatcher == null) {
            return;
        }
        double d0 = this.entityRenderDispatcher.distanceToSqr(npc);
        if (d0 > 512.0) {
            return;
        }
        matrixStack.pushPose();
        Vec3 renderOffset = this.getRenderOffset((Entity)npc, 0.0f);
        matrixStack.translate(-renderOffset.x(), -renderOffset.y(), -renderOffset.z());
        if (((EntityNPCInterface)((Object)npc)).messages != null) {
            float height = ((EntityNPCInterface)((Object)npc)).baseSize.height() / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
            float offset = npc.getBbHeight() * (1.2f + (!((EntityNPCInterface)((Object)npc)).display.showName() ? 0.0f : (((EntityNPCInterface)((Object)npc)).display.getTitle().isEmpty() ? 0.15f : 0.25f)));
            matrixStack.translate(0.0f, offset, 0.0f);
            ((EntityNPCInterface)((Object)npc)).messages.renderMessages(matrixStack, buffer, 0.666667f * height, ((EntityNPCInterface)((Object)npc)).isInRange(this.entityRenderDispatcher.camera.getEntity(), 4.0), light);
            matrixStack.translate(0.0f, -offset, 0.0f);
        }
        if (((EntityNPCInterface)((Object)npc)).display.showName()) {
            this.renderLivingLabel(npc, matrixStack, buffer, light);
        }
        matrixStack.popPose();
    }

    protected void renderLivingLabel(T npc, PoseStack matrixStack, MultiBufferSource buffer, int light) {
        boolean nearby;
        float scale = ((EntityNPCInterface)((Object)npc)).baseSize.height() / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        float height = npc.getBbHeight() - 0.06f * scale;
        matrixStack.pushPose();
        Font fontrenderer = this.getFont();
        float f2 = 0.01666667f * scale;
        matrixStack.translate(0.0f, height, 0.0f);
        matrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        int color = ((EntityNPCInterface)((Object)npc)).getFaction().color;
        matrixStack.translate(0.0f, scale / 6.5f * 2.0f, 0.0f);
        float f1 = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        matrixStack.scale(f2, -f2, f2);
        Matrix4f matrix4f = matrixStack.last().pose();
        float y = 0.0f;
        boolean bl = nearby = !npc.isDiscrete();
        if (!((EntityNPCInterface)((Object)npc)).display.getTitle().isEmpty() && ((EntityNPCInterface)((Object)npc)).isInRange(this.entityRenderDispatcher.camera.getEntity(), 8.0)) {
            MutableComponent title = Component.literal((String)"<").append((Component)Component.translatable((String)((EntityNPCInterface)((Object)npc)).display.getTitle())).append(">");
            float f3 = 0.6f;
            matrixStack.translate(0.0f, 4.0f, 0.0f);
            matrixStack.scale(f3, f3, f3);
            fontrenderer.drawInBatch((Component)title, (float)(-fontrenderer.width((FormattedText)title) / 2), 0.0f, color, false, matrix4f, buffer, nearby ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, light);
            if (nearby) {
                fontrenderer.drawInBatch((Component)title, (float)(-fontrenderer.width((FormattedText)title) / 2), 0.0f, color, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, light);
            }
            matrixStack.scale(1.0f / f3, 1.0f / f3, 1.0f / f3);
            y = -10.0f;
        }
        Component name = ((EntityNPCInterface)((Object)npc)).getName();
        fontrenderer.drawInBatch(name, (float)(-fontrenderer.width((FormattedText)name) / 2), y, color, false, matrix4f, buffer, nearby ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, light);
        if (nearby) {
            fontrenderer.drawInBatch(name, (float)(-fontrenderer.width((FormattedText)name) / 2), y, color, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, light);
        }
        matrixStack.popPose();
    }

    protected void renderColor(EntityNPCInterface npc) {
        if (npc.hurtTime <= 0 && npc.deathTime <= 0) {
            float red = (float)(npc.display.getTint() >> 16 & 0xFF) / 255.0f;
            float green = (float)(npc.display.getTint() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(npc.display.getTint() & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        }
    }

    protected void setupRotations(T npc, PoseStack matrixScale, float bob, float yBodyRot, float partialTick, float scale1) {
        if (((EntityNPCInterface)((Object)npc)).isAlive() && ((EntityNPCInterface)((Object)npc)).isSleeping()) {
            matrixScale.mulPose(Axis.YP.rotationDegrees((float)((EntityNPCInterface)((Object)npc)).ais.orientation));
            matrixScale.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees((LivingEntity)npc)));
            matrixScale.mulPose(Axis.YP.rotationDegrees(270.0f));
        } else if (((EntityNPCInterface)((Object)npc)).isAlive() && ((EntityNPCInterface)((Object)npc)).currentAnimation == 7) {
            matrixScale.mulPose(Axis.YP.rotationDegrees(270.0f - yBodyRot));
            float scale = (float)((EntityCustomNpc)((Object)npc)).display.getSize() / 5.0f;
            matrixScale.translate(-scale + ((EntityCustomNpc)((Object)npc)).modelData.getLegsY() * scale, 0.14f, 0.0f);
            matrixScale.mulPose(Axis.ZP.rotationDegrees(270.0f));
            matrixScale.mulPose(Axis.YP.rotationDegrees(270.0f));
        } else {
            super.setupRotations(npc, matrixScale, bob, yBodyRot, partialTick, scale1);
        }
    }

    protected void scale(T npc, PoseStack matrixScale, float f) {
        this.renderColor((EntityNPCInterface)((Object)npc));
        int size = ((EntityNPCInterface)((Object)npc)).display.getSize();
        matrixScale.scale(((EntityNPCInterface)((Object)npc)).scaleX / 5.0f * (float)size, ((EntityNPCInterface)((Object)npc)).scaleY / 5.0f * (float)size, ((EntityNPCInterface)((Object)npc)).scaleZ / 5.0f * (float)size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(T npc, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        if (((EntityNPCInterface)((Object)npc)).isKilled()) {
            this.shadowRadius = 0.0f;
        }
        if (((EntityNPCInterface)((Object)npc)).isKilled() && ((EntityNPCInterface)((Object)npc)).stats.hideKilledBody && ((EntityNPCInterface)((Object)npc)).deathTime > 20) {
            return;
        }
        float xOffset = 0.0f;
        float yOffset = ((EntityNPCInterface)((Object)npc)).currentAnimation == 0 ? ((EntityNPCInterface)((Object)npc)).ais.bodyOffsetY / 10.0f - 0.5f : 0.0f;
        float zOffset = 0.0f;
        if (((EntityNPCInterface)((Object)npc)).isAlive()) {
            if (((EntityNPCInterface)((Object)npc)).isSleeping()) {
                xOffset = (float)(-Math.cos(Math.toRadians(180 - ((EntityNPCInterface)((Object)npc)).ais.orientation)));
                zOffset = (float)(-Math.sin(Math.toRadians(((EntityNPCInterface)((Object)npc)).ais.orientation)));
                yOffset += 0.14f;
            } else if (((EntityNPCInterface)((Object)npc)).currentAnimation == 1 || npc.isPassenger()) {
                yOffset -= 0.5f - ((EntityCustomNpc)((Object)npc)).modelData.getLegsY() * 0.8f;
            }
        }
        xOffset = xOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        yOffset = yOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        zOffset = zOffset / 5.0f * (float)((EntityNPCInterface)((Object)npc)).display.getSize();
        if (((EntityNPCInterface)((Object)npc)).display.getBossbar() != 1 && (((EntityNPCInterface)((Object)npc)).display.getBossbar() != 2 || !((EntityNPCInterface)((Object)npc)).isAttacking()) || ((EntityNPCInterface)((Object)npc)).isKilled() || ((EntityNPCInterface)((Object)npc)).deathTime > 20 || ((EntityNPCInterface)((Object)npc)).canNpcSee((Entity)Minecraft.getInstance().player)) {
            // empty if block
        }
        if (((EntityNPCInterface)((Object)npc)).ais.getStandingType() == 3 && !((EntityNPCInterface)((Object)npc)).isWalking() && !((EntityNPCInterface)((Object)npc)).isInteracting()) {
            ((EntityNPCInterface)((Object)npc)).yBodyRotO = ((EntityNPCInterface)((Object)npc)).yBodyRot = (float)((EntityNPCInterface)((Object)npc)).ais.orientation;
        }
        this.shadowRadius = npc.getBbWidth() * 0.8f;
        int stackSize = ((MatrixStackMixin)matrixStack).getStack().size();
        try {
            currentNpc = npc;
            super.render(npc, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        }
        catch (Throwable e) {
            while (((MatrixStackMixin)matrixStack).getStack().size() > stackSize) {
                matrixStack.popPose();
            }
            LogWriter.except(e);
        }
        finally {
            currentNpc = null;
        }
    }

    protected float getBob(T npc, float limbSwingAmount) {
        if (((EntityNPCInterface)((Object)npc)).isKilled() || !((EntityNPCInterface)((Object)npc)).display.getHasLivingAnimation()) {
            return 0.0f;
        }
        return super.getBob(npc, limbSwingAmount);
    }

    public ResourceLocation getTextureLocation(T npc) {
        if (((EntityNPCInterface)((Object)npc)).textureLocation == null) {
            if (((EntityNPCInterface)((Object)npc)).display.skinType == 0) {
                ((EntityNPCInterface)((Object)npc)).textureLocation = ResourceLocation.tryParse((String)((EntityNPCInterface)((Object)npc)).display.getSkinTexture());
            } else {
                if (LastTextureTick < 5) {
                    return DefaultPlayerSkin.getDefaultTexture();
                }
                if (((EntityNPCInterface)((Object)npc)).display.skinType == 1 && ((EntityNPCInterface)((Object)npc)).display.playerProfile != null) {
                    Minecraft minecraft = Minecraft.getInstance();
                    PlayerSkin skin = minecraft.getSkinManager().getInsecureSkin(((EntityNPCInterface)((Object)npc)).display.playerProfile);
                    ((EntityNPCInterface)((Object)npc)).textureLocation = skin.texture();
                } else if (((EntityNPCInterface)((Object)npc)).display.skinType == 2 && !((EntityNPCInterface)((Object)npc)).display.getSkinUrl().isEmpty()) {
                    try {
                        boolean fixSkin = npc instanceof EntityCustomNpc && ((EntityCustomNpc)((Object)npc)).modelData.getEntity((EntityNPCInterface)((Object)npc)) == null;
                        File file = ResourceDownloader.getUrlFile(((EntityNPCInterface)((Object)npc)).display.getSkinUrl(), fixSkin);
                        ((EntityNPCInterface)((Object)npc)).textureLocation = ResourceDownloader.getUrlResourceLocation(((EntityNPCInterface)((Object)npc)).display.getSkinUrl(), fixSkin);
                        this.loadSkin(file, ((EntityNPCInterface)((Object)npc)).textureLocation, ((EntityNPCInterface)((Object)npc)).display.getSkinUrl(), fixSkin);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        if (((EntityNPCInterface)((Object)npc)).textureLocation == null) {
            return DefaultPlayerSkin.getDefaultTexture();
        }
        return ((EntityNPCInterface)((Object)npc)).textureLocation;
    }

    private void loadSkin(File file, ResourceLocation resource, String par1Str, boolean fix64) {
        TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
        AbstractTexture object = texturemanager.getTexture(resource, null);
        if (object == null) {
            ResourceDownloader.load(new ImageDownloadAlt(file, par1Str, resource, DefaultPlayerSkin.getDefaultTexture(), fix64, () -> {}));
        }
    }
}

