/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.renderer.blocks.BlockRendererInterface;

public class BlockScriptedRenderer
extends BlockRendererInterface<TileScripted> {
    private static RandomSource random = RandomSource.create();

    public BlockScriptedRenderer(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
    }

    public void render(TileScripted tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        matrixStack.pushPose();
        if (this.overrideModel()) {
            matrixStack.translate(0.5f, 0.5f, 0.5f);
            matrixStack.scale(2.0f, 2.0f, 2.0f);
            this.renderItem(new ItemStack((ItemLike)CustomBlocks.scripted), matrixStack, buffer, light, overlay);
        } else {
            matrixStack.mulPose(Axis.YP.rotationDegrees((float)tile.rotationY));
            matrixStack.mulPose(Axis.XP.rotationDegrees((float)tile.rotationX));
            matrixStack.mulPose(Axis.ZP.rotationDegrees((float)tile.rotationZ));
            matrixStack.scale(tile.scaleX, tile.scaleY, tile.scaleZ);
            Block b = tile.blockModel;
            if (b == null || b == Blocks.AIR || b == CustomBlocks.scripted) {
                matrixStack.translate(0.5f, 0.5f, 0.5f);
                matrixStack.scale(2.0f, 2.0f, 2.0f);
                this.renderItem(tile.itemModel, matrixStack, buffer, light, overlay);
            } else {
                BlockState state = b.defaultBlockState();
                this.renderBlock(tile, b, state, matrixStack, buffer, light, overlay);
                if (state.hasBlockEntity() && !tile.renderTileErrored) {
                    try {
                        BlockEntityRenderer renderer;
                        if (tile.renderTile == null) {
                            BlockEntity entity = ((EntityBlock)b).newBlockEntity(tile.getBlockPos(), state);
                            entity.setLevel(tile.getLevel());
                            tile.renderTile = entity;
                            tile.renderState = state;
                            tile.renderTileUpdate = ((EntityBlock)b).getTicker(tile.getLevel(), state, entity.getType());
                        }
                        if ((renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(tile.renderTile)) != null) {
                            renderer.render(tile.renderTile, partialTicks, matrixStack, buffer, light, overlay);
                        } else {
                            tile.renderTileErrored = true;
                        }
                    }
                    catch (Exception e) {
                        tile.renderTileErrored = true;
                    }
                }
            }
        }
        matrixStack.popPose();
        if (!tile.text1.text.isEmpty()) {
            this.drawText(matrixStack, tile.text1, buffer, light, overlay);
        }
        if (!tile.text2.text.isEmpty()) {
            this.drawText(matrixStack, tile.text2, buffer, light, overlay);
        }
        if (!tile.text3.text.isEmpty()) {
            this.drawText(matrixStack, tile.text3, buffer, light, overlay);
        }
        if (!tile.text4.text.isEmpty()) {
            this.drawText(matrixStack, tile.text4, buffer, light, overlay);
        }
        if (!tile.text5.text.isEmpty()) {
            this.drawText(matrixStack, tile.text5, buffer, light, overlay);
        }
        if (!tile.text6.text.isEmpty()) {
            this.drawText(matrixStack, tile.text6, buffer, light, overlay);
        }
    }

    private void drawText(PoseStack matrixStack, TileScripted.TextPlane text1, MultiBufferSource buffer, int light, int overlay) {
        if (text1.textBlock == null || text1.textHasChanged) {
            text1.textBlock = new TextBlockClient(text1.text, 336, true, Minecraft.getInstance().player);
            text1.textHasChanged = false;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        matrixStack.mulPose(Axis.YP.rotationDegrees((float)text1.rotationY));
        matrixStack.mulPose(Axis.XP.rotationDegrees((float)text1.rotationX));
        matrixStack.mulPose(Axis.ZP.rotationDegrees((float)text1.rotationZ));
        matrixStack.scale(text1.scale, text1.scale, 1.0f);
        matrixStack.translate(text1.offsetX, text1.offsetY, text1.offsetZ);
        float f1 = 0.6666667f;
        float f3 = 0.0133f * f1;
        matrixStack.translate(0.0f, 0.5f, 0.01f);
        matrixStack.scale(f3, -f3, f3);
        Font fontrenderer = Minecraft.getInstance().font;
        float lineOffset = 0.0f;
        if (text1.textBlock.lines.size() < 14) {
            lineOffset = (14.0f - (float)text1.textBlock.lines.size()) / 2.0f;
        }
        for (int i = 0; i < text1.textBlock.lines.size(); ++i) {
            Component text = text1.textBlock.lines.get(i);
            float f = -fontrenderer.width((FormattedText)text) / 2;
            double d = lineOffset + (float)i;
            Objects.requireNonNull(fontrenderer);
            fontrenderer.drawInBatch(text, f, (float)((int)(d * (9.0 - 0.3))), 0, false, matrixStack.last().pose(), buffer, Font.DisplayMode.NORMAL, light, overlay);
        }
        matrixStack.popPose();
    }

    private void renderItem(ItemStack item, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, matrixStack, buffer, null, 0);
    }

    private void renderBlock(TileScripted tile, Block b, BlockState state, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        matrixStack.pushPose();
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStack, buffer, light, OverlayTexture.NO_OVERLAY);
        if (random.nextInt(12) == 1) {
            state.getBlock().animateTick(state, tile.getLevel(), tile.getBlockPos(), random);
        }
        matrixStack.popPose();
    }

    private boolean overrideModel() {
        ItemStack held = Minecraft.getInstance().player.getMainHandItem();
        if (held == null) {
            return false;
        }
        return held.getItem() == CustomItems.wand || held.getItem() == CustomItems.scripter;
    }
}

