/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import noppes.npcs.command.CmdNoppes;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;

public class CmdClone {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = Commands.literal((String)"clone");
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"list").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"tab", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int tab = IntegerArgumentType.getInteger((CommandContext)context, (String)"tab");
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"--- Stored NPCs --- (server side)"), false);
            for (String name : ServerCloneController.Instance.getClones(tab)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)name), false);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"------------------------------------"), false);
            return 1;
        })));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"npc", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"tab", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            CmdClone.addClone((CommandContext<CommandSourceStack>)context, "");
            return 1;
        })).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            CmdClone.addClone((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name"));
            return 1;
        })))));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"npc", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"tab", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            String nametodel = StringArgumentType.getString((CommandContext)context, (String)"npc");
            int tab = IntegerArgumentType.getInteger((CommandContext)context, (String)"tab");
            boolean deleted = false;
            for (String name : ServerCloneController.Instance.getClones(tab)) {
                if (!nametodel.equalsIgnoreCase(name)) continue;
                ServerCloneController.Instance.removeClone(name, tab);
                deleted = true;
                break;
            }
            if (!deleted) {
                throw new SimpleCommandExceptionType((Message)Component.translatable((String)"Npc '%s' wasn't found", (Object[])new Object[]{nametodel})).create();
            }
            return 1;
        }))));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"spawn").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"npc", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"tab", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            CmdClone.spawnClone((CommandContext<CommandSourceStack>)context, new BlockPos((int)((CommandSourceStack)context.getSource()).getPosition().x, (int)((CommandSourceStack)context.getSource()).getPosition().y, (int)((CommandSourceStack)context.getSource()).getPosition().z), "");
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            CmdClone.spawnClone((CommandContext<CommandSourceStack>)context, BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos"), "");
            return 1;
        })).then(Commands.argument((String)"display_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            CmdClone.spawnClone((CommandContext<CommandSourceStack>)context, BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos"), StringArgumentType.getString((CommandContext)context, (String)"display_name"));
            return 1;
        }))))));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"grid").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"npc", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"tab", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"length", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.argument((String)"width", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int length = IntegerArgumentType.getInteger((CommandContext)context, (String)"length");
            int width = IntegerArgumentType.getInteger((CommandContext)context, (String)"width");
            for (int x = 0; x < length; ++x) {
                for (int z = 0; z < width; ++z) {
                    CmdClone.spawnClone((CommandContext<CommandSourceStack>)context, new BlockPos((int)((CommandSourceStack)context.getSource()).getPosition().x, (int)((CommandSourceStack)context.getSource()).getPosition().y, (int)((CommandSourceStack)context.getSource()).getPosition().z).offset(length, 0, width), "");
                }
            }
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            int length = IntegerArgumentType.getInteger((CommandContext)context, (String)"length");
            int width = IntegerArgumentType.getInteger((CommandContext)context, (String)"width");
            for (int x = 0; x < length; ++x) {
                for (int z = 0; z < width; ++z) {
                    CmdClone.spawnClone((CommandContext<CommandSourceStack>)context, BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos").offset(length, 0, width), "");
                }
            }
            return 1;
        })).then(Commands.argument((String)"display_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            int length = IntegerArgumentType.getInteger((CommandContext)context, (String)"length");
            int width = IntegerArgumentType.getInteger((CommandContext)context, (String)"width");
            for (int x = 0; x < length; ++x) {
                for (int z = 0; z < width; ++z) {
                    CmdClone.spawnClone((CommandContext<CommandSourceStack>)context, BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos").offset(length, 0, width), StringArgumentType.getString((CommandContext)context, (String)"display_name"));
                }
            }
            return 1;
        }))))))));
        return command;
    }

    private static void addClone(CommandContext<CommandSourceStack> context, String newName) {
        CompoundTag compound;
        String name = StringArgumentType.getString(context, (String)"npc");
        if (newName.isEmpty()) {
            newName = name;
        }
        int tab = IntegerArgumentType.getInteger(context, (String)"tab");
        List<EntityNPCInterface> list = CmdNoppes.getNpcsByName(((CommandSourceStack)context.getSource()).getLevel(), name);
        if (list.isEmpty()) {
            return;
        }
        EntityNPCInterface npc = list.get(0);
        if (!npc.saveAsPassenger(compound = new CompoundTag())) {
            return;
        }
        ServerCloneController.Instance.addClone(compound, newName, tab);
    }

    private static void spawnClone(CommandContext<CommandSourceStack> context, BlockPos pos, String newName) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"npc").replaceAll("%", " ");
        int tab = IntegerArgumentType.getInteger(context, (String)"tab");
        CompoundTag compound = ServerCloneController.Instance.getCloneData((CommandSourceStack)context.getSource(), name, tab);
        if (compound == null) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown npc")).create();
        }
        if (pos == BlockPos.ZERO) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"Location needed")).create();
        }
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        Entity entity = (Entity)EntityType.create((CompoundTag)compound, (Level)world).get();
        entity.setPos((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ais.setStartPos(pos);
            if (!newName.isEmpty()) {
                npc.display.setName(newName.replaceAll("%", " "));
            }
        }
        world.addFreshEntity(entity);
    }
}

