/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;

public class CmdFaction {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"faction").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"faction", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.literal((String)"add").then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Faction faction = FactionController.instance.factions.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"faction"));
            if (faction == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown FactionID")).create();
            }
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            for (ServerPlayer player : players) {
                PlayerData data = PlayerData.get((Player)player);
                PlayerFactionData playerfactiondata = data.factionData;
                playerfactiondata.increasePoints((Player)player, faction.id, points);
                data.save(true);
            }
            return 1;
        })))).then(Commands.literal((String)"set").then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Faction faction = FactionController.instance.factions.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"faction"));
            if (faction == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown FactionID")).create();
            }
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            for (ServerPlayer player : players) {
                PlayerData data = PlayerData.get((Player)player);
                PlayerFactionData playerfactiondata = data.factionData;
                playerfactiondata.factionData.put(faction.id, points);
                data.save(true);
            }
            return 1;
        })))).then(Commands.literal((String)"reset").executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Faction faction = FactionController.instance.factions.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"faction"));
            if (faction == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown FactionID")).create();
            }
            for (ServerPlayer player : players) {
                PlayerData data = PlayerData.get((Player)player);
                data.factionData.factionData.put(faction.id, faction.defaultPoints);
                data.save(true);
            }
            return 1;
        }))).then(Commands.literal((String)"drop").executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Faction faction = FactionController.instance.factions.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"faction"));
            if (faction == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown FactionID")).create();
            }
            for (ServerPlayer player : players) {
                PlayerData data = PlayerData.get((Player)player);
                data.factionData.factionData.remove(faction.id);
                data.save(true);
            }
            return 1;
        }))));
        return command;
    }
}

