/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomNpcs;
import noppes.npcs.command.CmdNoppes;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;

public class CmdNPC {
    public static final SuggestionProvider<CommandSourceStack> VISIBLE = SuggestionProviders.register((ResourceLocation)ResourceLocation.tryParse((String)"visible"), (context, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"true", "false", "semi"}, (SuggestionsBuilder)builder));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"npc").requires(source -> source.hasPermission(CustomNpcs.NoppesCommandOpOnly ? 4 : 2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"npc", (ArgumentType)StringArgumentType.string()).then(Commands.literal((String)"home").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"npc");
            List<EntityNPCInterface> npcs = CmdNoppes.getNpcsByName(((CommandSourceStack)context.getSource()).getLevel(), name);
            if (!npcs.isEmpty()) {
                npcs.get((int)0).ais.setStartPos(BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos"));
            }
            return 1;
        })))).then(Commands.literal((String)"visible").then(Commands.argument((String)"visibility", (ArgumentType)StringArgumentType.word()).suggests(VISIBLE).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"npc");
            List<EntityNPCInterface> npcs = CmdNoppes.getNpcsByName(((CommandSourceStack)context.getSource()).getLevel(), name);
            String val = StringArgumentType.getString((CommandContext)context, (String)"visibility");
            int vis = 0;
            if (val.equalsIgnoreCase("false")) {
                vis = 1;
            } else if (val.equalsIgnoreCase("semi")) {
                vis = 2;
            }
            for (EntityNPCInterface npc : npcs) {
                npc.display.setVisible(vis);
            }
            return 1;
        })))).then(Commands.literal((String)"delete").executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"npc");
            List<EntityNPCInterface> npcs = CmdNoppes.getNpcsByName(((CommandSourceStack)context.getSource()).getLevel(), name);
            for (EntityNPCInterface npc : npcs) {
                npc.delete();
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"owner").executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"npc");
            List<EntityNPCInterface> npcs = CmdNoppes.getNpcsByName(((CommandSourceStack)context.getSource()).getLevel(), name);
            for (EntityNPCInterface npc : npcs) {
                LivingEntity owner = npc.getOwner();
                if (owner == null) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"No owner"), false);
                    continue;
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Owner is: " + String.valueOf(owner.getName()))), false);
            }
            return 1;
        })).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"npc");
            List<EntityNPCInterface> npcs = CmdNoppes.getNpcsByName(((CommandSourceStack)context.getSource()).getLevel(), name);
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            for (EntityNPCInterface npc : npcs) {
                if (npc.role instanceof RoleFollower) {
                    ((RoleFollower)npc.role).setOwner((Player)player);
                }
                if (!(npc.role instanceof RoleCompanion)) continue;
                ((RoleCompanion)npc.role).setOwner((Player)player);
            }
            return 1;
        })))).then(Commands.literal((String)"delete").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            List<EntityNPCInterface> npcs = CmdNoppes.getNpcsByName(((CommandSourceStack)context.getSource()).getLevel(), StringArgumentType.getString((CommandContext)context, (String)"npc"));
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            for (EntityNPCInterface npc : npcs) {
                npc.display.setName(name);
                npc.updateClient = true;
            }
            return 1;
        })))).then(Commands.literal((String)"reset").executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"npc");
            List<EntityNPCInterface> npcs = CmdNoppes.getNpcsByName(((CommandSourceStack)context.getSource()).getLevel(), name);
            for (EntityNPCInterface npc : npcs) {
                npc.reset();
            }
            return 1;
        }))).then(Commands.literal((String)"create").executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"npc");
            ServerLevel pw = ((CommandSourceStack)context.getSource()).getLevel();
            EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, (Level)pw);
            npc.display.setName(name);
            Vec3 pos = ((CommandSourceStack)context.getSource()).getPosition();
            npc.absMoveTo(pos.x, pos.y, pos.z, 0.0f, 0.0f);
            npc.ais.setStartPos(new BlockPos((int)pos.x, (int)pos.y, (int)pos.z));
            pw.addFreshEntity((Entity)npc);
            npc.setHealth(npc.getMaxHealth());
            return 1;
        })));
        return command;
    }
}

