/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.schematics.SchematicWrapper;

public class CmdSchematics {
    public static final List<String> names = new ArrayList<String>();
    public static final SuggestionProvider<CommandSourceStack> SCHEMAS = SuggestionProviders.register((ResourceLocation)ResourceLocation.tryParse((String)"schemas"), (context, builder) -> SharedSuggestionProvider.suggest(names.stream(), (SuggestionsBuilder)builder));
    public static final SuggestionProvider<CommandSourceStack> ROTATION = SuggestionProviders.register((ResourceLocation)ResourceLocation.tryParse((String)"rotation"), (context, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"0", "90", "180", "270"}, (SuggestionsBuilder)builder));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"schema").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"build").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(SCHEMAS).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"rotation", (ArgumentType)StringArgumentType.word()).suggests(ROTATION).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"pos");
            int rotation = Integer.parseInt(StringArgumentType.getString((CommandContext)context, (String)"rotation"));
            SchematicWrapper schem = SchematicController.Instance.load(name);
            schem.init(pos, (Level)((CommandSourceStack)context.getSource()).getLevel(), rotation);
            SchematicController.Instance.build(schem, (CommandSourceStack)context.getSource());
            return 1;
        })))))).then(Commands.literal((String)"stop").executes(context -> {
            SchematicController.Instance.stop((CommandSourceStack)context.getSource());
            return 1;
        }))).then(Commands.literal((String)"info").executes(context -> {
            SchematicController.Instance.info((CommandSourceStack)context.getSource());
            return 1;
        }))).then(Commands.literal((String)"list").executes(context -> {
            List<String> list = SchematicController.Instance.list();
            if (list.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"No schemas available"), false);
                return 1;
            }
            Object s = "";
            for (String file : list) {
                s = (String)s + file + ", ";
            }
            String finalS = s;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)finalS), false);
            return 1;
        }));
        return command;
    }
}

