/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.containers;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.NoppesUtilServer;

public class InventoryNPC
implements Container {
    private String inventoryTitle;
    private int slotsCount;
    public final NonNullList<ItemStack> inventoryContents;
    private AbstractContainerMenu con;

    public InventoryNPC(String s, int i, AbstractContainerMenu con) {
        this.con = con;
        this.inventoryTitle = s;
        this.slotsCount = i;
        this.inventoryContents = NonNullList.withSize((int)i, (Object)ItemStack.EMPTY);
    }

    public ItemStack getItem(int i) {
        return (ItemStack)this.inventoryContents.get(i);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.inventoryContents, (int)index, (int)count);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public int getContainerSize() {
        return this.slotsCount;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean stillValid(Player entityplayer) {
        return false;
    }

    public ItemStack removeItemNoUpdate(int i) {
        return ContainerHelper.takeItem(this.inventoryContents, (int)i);
    }

    public boolean canPlaceItem(int i, ItemStack itemstack) {
        return true;
    }

    public void setChanged() {
        this.con.slotsChanged((Container)this);
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean isEmpty() {
        for (int slot = 0; slot < this.getContainerSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (NoppesUtilServer.IsItemStackNull(item) || item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clearContent() {
    }
}

