/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import noppes.npcs.ModelData;
import noppes.npcs.ModelEyeData;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.client.parts.MpmPartData;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityNPCFlying;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.EntityIMixin;

public class EntityCustomNpc
extends EntityNPCFlying {
    public ModelData modelData = new ModelData(this);

    public EntityCustomNpc(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("NpcModelData")) {
            this.modelData.load(compound.getCompound("NpcModelData"));
        }
        super.readAdditionalSaveData(compound);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("NpcModelData", (Tag)this.modelData.save());
    }

    public boolean saveAsPassenger(CompoundTag compound) {
        String s;
        boolean bo = super.saveAsPassenger(compound);
        if (bo && (s = this.getEncodeId()).equals("minecraft:customnpcs.customnpc")) {
            compound.putString("id", "customnpcs:customnpc");
        }
        return bo;
    }

    @Override
    public void tick() {
        LivingEntity entity;
        super.tick();
        if (this.isClientSide() && (entity = this.modelData.getEntity(this)) != null) {
            try {
                entity.tick();
            }
            catch (Exception exception) {
                // empty catch block
            }
            EntityUtil.Copy((LivingEntity)this, entity);
        }
        for (MpmPartData pd : this.modelData.mpmParts) {
            if (!(pd instanceof ModelEyeData)) continue;
            ((ModelEyeData)pd).update((LivingEntity)this);
        }
    }

    public boolean startRiding(Entity par1Entity, boolean force) {
        boolean b = super.startRiding(par1Entity, force);
        this.refreshDimensions();
        return b;
    }

    public void refreshDimensions() {
        LivingEntity entity = this.modelData.getEntity(this);
        if (entity != null) {
            entity.refreshDimensions();
        }
        super.refreshDimensions();
    }

    @Override
    public EntityDimensions getDimensions(Pose pos) {
        LivingEntity entity = this.modelData.getEntity(this);
        if (entity == null) {
            float height = 1.9f - this.modelData.getBodyY() + (this.modelData.getPartConfig((EnumParts)EnumParts.HEAD).scaleY - 1.0f) / 2.0f;
            if (this.baseSize.height() != height) {
                this.baseSize = EntityDimensions.scalable((float)this.baseSize.width(), (float)height);
            }
            return super.getDimensions(pos);
        }
        EntityDimensions size = entity.getDimensions(pos);
        if (entity instanceof EntityNPCInterface) {
            return size.scale((float)this.display.getSize() * 0.2f);
        }
        float width = size.width() / 5.0f * (float)this.display.getSize();
        float height = size.height() / 5.0f * (float)this.display.getSize();
        if (width < 0.1f) {
            width = 0.1f;
        }
        if (height < 0.1f) {
            height = 0.1f;
        }
        if (this.display.getHitboxState() == 1 || this.isKilled() && this.stats.hideKilledBody) {
            width = 1.0E-5f;
        }
        return EntityDimensions.scalable((float)width, (float)height);
    }

    public Vec3 getPassengerAttachmentPoint(Entity e, EntityDimensions dimensions, float partialTick) {
        LivingEntity entity = this.modelData.getEntity(this);
        if (entity != null) {
            return ((EntityIMixin)entity).invokeGetPassengerAttachmentPoint(e, dimensions, partialTick).scale(0.2).scale((double)this.display.getSize());
        }
        return super.getPassengerAttachmentPoint(e, dimensions, partialTick);
    }
}

