/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import noppes.npcs.CustomEntities;
import noppes.npcs.ModelData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityNpcDragon
extends EntityNPCInterface {
    private EntityDimensions size = EntityDimensions.scalable((float)1.8f, (float)1.4f);
    public double[][] field_40162_d = new double[64][3];
    public int field_40164_e = -1;
    public float prevAnimTime = 0.0f;
    public float animTime = 0.0f;
    public int field_40178_aA = 0;
    public boolean isFlying = false;
    private boolean exploded = false;

    public EntityNpcDragon(EntityType<? extends EntityNPCInterface> type, Level world) {
        super(type, world);
        this.scaleX = 0.4f;
        this.scaleY = 0.4f;
        this.scaleZ = 0.4f;
        this.display.setSkinTexture("customnpcs:textures/entity/dragon/blackdragon.png");
    }

    public Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return new Vec3(0.0, (double)1.1f, 0.0);
    }

    public double[] getMovementOffsets(int i, float f) {
        double d1;
        f = 1.0f - f;
        int j = this.field_40164_e - i * 1 & 0x3F;
        int k = this.field_40164_e - i * 1 - 1 & 0x3F;
        double[] ad = new double[3];
        double d = this.field_40162_d[j][0];
        for (d1 = this.field_40162_d[k][0] - d; d1 < -180.0; d1 += 360.0) {
        }
        while (d1 >= 180.0) {
            d1 -= 360.0;
        }
        ad[0] = d + d1 * (double)f;
        d = this.field_40162_d[j][1];
        d1 = this.field_40162_d[k][1] - d;
        ad[1] = d + d1 * (double)f;
        ad[2] = this.field_40162_d[j][2] + (this.field_40162_d[k][2] - this.field_40162_d[j][2]) * (double)f;
        return ad;
    }

    @Override
    public void tick() {
        this.discard();
        this.setNoAi(true);
        if (!this.level().isClientSide) {
            CompoundTag compound = new CompoundTag();
            this.addAdditionalSaveData(compound);
            EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, this.level());
            npc.readAdditionalSaveData(compound);
            ModelData data = npc.modelData;
            data.setEntity(BuiltInRegistries.ENTITY_TYPE.getKey(CustomEntities.entityNpcDragon));
            this.level().addFreshEntity((Entity)npc);
        }
        super.tick();
    }

    @Override
    public void aiStep() {
        this.prevAnimTime = this.animTime;
        if (this.level().isClientSide && this.getHealth() <= 0.0f) {
            if (!this.exploded) {
                this.exploded = true;
                float f = (this.random.nextFloat() - 0.5f) * 8.0f;
                float f2 = (this.random.nextFloat() - 0.5f) * 4.0f;
                float f4 = (this.random.nextFloat() - 0.5f) * 8.0f;
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (double)f, this.getY() + 2.0 + (double)f2, this.getZ() + (double)f4, 0.0, 0.0, 0.0);
            }
        } else {
            this.exploded = false;
            float f1 = 0.045f;
            this.animTime += (f1 *= (float)Math.pow(2.0, this.getDeltaMovement().y)) * 0.5f;
        }
        super.aiStep();
    }

    @Override
    public EntityDimensions getDimensions(Pose pos) {
        return this.size;
    }
}

