/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import noppes.npcs.CustomEntities;
import noppes.npcs.ModelData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityNpcSlime
extends EntityNPCInterface {
    public EntityNpcSlime(EntityType<? extends EntityNPCInterface> type, Level world) {
        super(type, world);
        this.scaleX = 2.0f;
        this.scaleY = 2.0f;
        this.scaleZ = 2.0f;
        this.display.setSkinTexture("customnpcs:textures/entity/slime/slime.png");
        this.baseSize = EntityDimensions.scalable((float)0.8f, (float)0.8f);
    }

    @Override
    public EntityDimensions getDimensions(Pose pos) {
        return EntityDimensions.scalable((float)0.8f, (float)0.8f);
    }

    @Override
    public void tick() {
        this.discard();
        this.setNoAi(true);
        if (!this.level().isClientSide) {
            CompoundTag compound = new CompoundTag();
            this.addAdditionalSaveData(compound);
            EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, this.level());
            npc.readAdditionalSaveData(compound);
            ModelData data = npc.modelData;
            data.setEntity(BuiltInRegistries.ENTITY_TYPE.getKey(CustomEntities.entityNpcSlime));
            this.level().addFreshEntity((Entity)npc);
        }
        super.tick();
    }
}

