/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemDataComponents;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;

public class ItemSoulstoneFilled
extends Item {
    public ItemSoulstoneFilled() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        if (!stack.has(ItemDataComponents.SOULSTONE_DATA)) {
            list.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Error")));
            return;
        }
        CompoundTag compound = ((CustomData)stack.get(ItemDataComponents.SOULSTONE_DATA)).getUnsafe();
        if (compound == null || !compound.contains("Entity", 10)) {
            list.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Error")));
            return;
        }
        MutableComponent name = Component.translatable((String)compound.getString("Name"));
        if (compound.contains("DisplayName")) {
            name = Component.translatable((String)compound.getString("DisplayName")).append(" (").append((Component)name).append(")");
        }
        list.add((Component)Component.literal((String)String.valueOf(ChatFormatting.BLUE)).append((Component)name));
        if (compound.contains("ExtraText")) {
            String[] split;
            MutableComponent text = Component.literal((String)"");
            for (String s : split = compound.getString("ExtraText").split(",")) {
                text.append((Component)Component.translatable((String)s));
            }
            list.add((Component)text);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.getItemInHand();
        if (ItemSoulstoneFilled.Spawn(context.getPlayer(), stack, context.getLevel(), context.getClickedPos()) == null) {
            return InteractionResult.FAIL;
        }
        if (!context.getPlayer().getAbilities().instabuild) {
            stack.split(1);
        }
        return InteractionResult.SUCCESS;
    }

    public static Entity Spawn(Player player, ItemStack stack, Level level, BlockPos pos) {
        if (level.isClientSide) {
            return null;
        }
        if (!stack.has(ItemDataComponents.SOULSTONE_DATA) || !((CustomData)stack.get(ItemDataComponents.SOULSTONE_DATA)).getUnsafe().contains("Entity", 10)) {
            return null;
        }
        CompoundTag compound = ((CustomData)stack.get(ItemDataComponents.SOULSTONE_DATA)).getUnsafe().getCompound("Entity");
        Entity entity = EntityType.create((CompoundTag)compound, (Level)level).orElse(null);
        if (entity == null) {
            return null;
        }
        entity.setPos((double)pos.getX() + 0.5, (double)((float)(pos.getY() + 1) + 0.2f), (double)pos.getZ() + 0.5);
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ais.setStartPos(pos);
            npc.setHealth(npc.getMaxHealth());
            npc.setPos((float)pos.getX() + 0.5f, npc.getStartYPos(), (float)pos.getZ() + 0.5f);
            if (npc.role.getType() == 6 && player != null) {
                PlayerData data = PlayerData.get(player);
                if (data.hasCompanion()) {
                    return null;
                }
                ((RoleCompanion)npc.role).setOwner(player);
                data.setCompanion(npc);
            }
            if (npc.role.getType() == 2 && player != null) {
                ((RoleFollower)npc.role).setOwner(player);
            }
        }
        if (!level.addFreshEntity(entity)) {
            player.sendSystemMessage((Component)Component.translatable((String)"error.failedToSpawn"));
            return null;
        }
        return entity;
    }
}

