/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.items.ItemScripted;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PersistentEntitySectionManager.class})
public abstract class MixinPersistentEntitySectionManager<T extends EntityAccess> {
    @Inject(method={"addEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void addEntity(T ent, boolean worldGenSpawned, CallbackInfoReturnable<Boolean> cir) {
        if (ent instanceof Entity) {
            Entity entity = (Entity)ent;
            if (entity.level().isClientSide || !(entity instanceof ItemEntity)) {
                return;
            }
            ItemEntity entityItem = (ItemEntity)entity;
            ItemStack stack = entityItem.getItem();
            if (!stack.isEmpty() && stack.getItem() == CustomItems.scripted_item && EventHooks.onScriptItemSpawn(ItemScripted.GetWrapper(stack), entityItem)) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

