/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.geom.ModelPart;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.constants.EnumParts;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.class})
public class ModelRendererMixin {
    public ModelPartConfig cnpcconfig;

    @Inject(at={@At(value="HEAD")}, method={"translateAndRotate"})
    private void translateAndRotatePre(PoseStack mStack, CallbackInfo callbackInfo) {
        this.cnpcconfig = this.getCnpcconfig();
        if (this.cnpcconfig != null) {
            mStack.translate(this.cnpcconfig.transX, this.cnpcconfig.transY, this.cnpcconfig.transZ);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"translateAndRotate"})
    private void translateAndRotatePost(PoseStack mStack, CallbackInfo callbackInfo) {
        this.cnpcconfig = this.getCnpcconfig();
        if (this.cnpcconfig != null) {
            mStack.scale(this.cnpcconfig.scaleX, this.cnpcconfig.scaleY, this.cnpcconfig.scaleZ);
        }
    }

    private ModelPartConfig getCnpcconfig() {
        if (ClientProxy.data == null) {
            return null;
        }
        ModelPart model = (ModelPart)this;
        if (model == ClientProxy.playerModel.body || model == ClientProxy.playerModel.jacket || model == ClientProxy.armorLayer.outerModel.body || model == ClientProxy.armorLayer.innerModel.body) {
            return ClientProxy.data.getPartConfig(EnumParts.BODY);
        }
        if (model == ClientProxy.playerModel.head || model == ClientProxy.playerModel.hat || model == ClientProxy.armorLayer.outerModel.head) {
            return ClientProxy.data.getPartConfig(EnumParts.HEAD);
        }
        if (model == ClientProxy.playerModel.leftLeg || model == ClientProxy.playerModel.leftPants || model == ClientProxy.armorLayer.outerModel.leftLeg || model == ClientProxy.armorLayer.innerModel.leftLeg) {
            return ClientProxy.data.getPartConfig(EnumParts.LEG_LEFT);
        }
        if (model == ClientProxy.playerModel.rightLeg || model == ClientProxy.playerModel.rightPants || model == ClientProxy.armorLayer.outerModel.rightLeg || model == ClientProxy.armorLayer.innerModel.rightLeg) {
            return ClientProxy.data.getPartConfig(EnumParts.LEG_RIGHT);
        }
        if (model == ClientProxy.playerModel.leftArm || model == ClientProxy.playerModel.leftSleeve || model == ClientProxy.armorLayer.outerModel.leftArm) {
            return ClientProxy.data.getPartConfig(EnumParts.ARM_LEFT);
        }
        if (model == ClientProxy.playerModel.rightArm || model == ClientProxy.playerModel.rightSleeve || model == ClientProxy.armorLayer.outerModel.rightArm) {
            return ClientProxy.data.getPartConfig(EnumParts.ARM_RIGHT);
        }
        return null;
    }
}

