/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin;

import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import noppes.npcs.NPCSpawning;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NoiseBasedChunkGenerator.class})
public class NoiseChunkGeneratorMixin {
    @Inject(at={@At(value="HEAD")}, method={"spawnOriginalMobs"}, cancellable=false)
    private void spawnOriginalMobs(WorldGenRegion region, CallbackInfo ci) {
        ChunkPos chunkpos = region.getCenter();
        int x = chunkpos.getMinBlockX();
        int z = chunkpos.getMinBlockZ();
        try {
            Holder biome = region.getBiome(new ChunkPos(x, z).getWorldPosition());
            NPCSpawning.performLevelGenSpawning((ServerLevelAccessor)region, (Biome)biome.value(), x, z, region.getRandom());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

