/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.entity.EntityNPCInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PacketServerBasic
implements CustomPacketPayload {
    private static final Logger LOGGER = LogManager.getLogger();
    public ServerPlayer player;
    public EntityNPCInterface npc;

    public boolean requiresNpc() {
        return false;
    }

    public PermissionNode<Boolean> getPermission() {
        return null;
    }

    public boolean toolAllowed(ItemStack item) {
        return item.getItem() == CustomItems.wand;
    }

    public static void handle(PacketServerBasic msg, MinecraftServer server, ServerPlayer player) {
        server.execute(() -> {
            msg.player = player;
            msg.npc = NoppesUtilServer.getEditingNpc((Player)msg.player);
            if (msg.requiresNpc() && msg.npc == null) {
                return;
            }
            if (msg.getPermission() != null && !CustomNpcsPermissions.hasPermission(msg.player, msg.getPermission())) {
                return;
            }
            if (!msg.toolAllowed(msg.player.getInventory().getSelected())) {
                msg.warn("tried to use custom npcs without a tool in hand, possibly a hacker");
                return;
            }
            msg.handle();
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(ResourceLocation.parse((String)("customnpcs:" + this.getClass().getSimpleName().toLowerCase())));
    }

    private void warn(String warning) {
        LOGGER.warn(this.player.getName().getString() + ": " + warning + " - " + String.valueOf(this));
    }

    protected abstract void handle();
}

