/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.BaseSpawnerMixin;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketToolMobSpawner
extends PacketServerBasic {
    private boolean createSpawner;
    private boolean server;
    private BlockPos pos;
    private String name = "";
    private int tab = -1;
    private CompoundTag clone = new CompoundTag();

    public SPacketToolMobSpawner(boolean createSpawner, BlockPos pos, String name, int tab) {
        this.server = true;
        this.createSpawner = createSpawner;
        this.pos = pos;
        this.name = name;
        this.tab = tab;
    }

    public SPacketToolMobSpawner(boolean createSpawner, BlockPos pos, CompoundTag clone) {
        this.server = false;
        this.createSpawner = createSpawner;
        this.pos = pos;
        this.clone = clone;
    }

    public SPacketToolMobSpawner(boolean createSpawner, boolean server, BlockPos pos, String name, int tab, CompoundTag clone) {
        this.createSpawner = createSpawner;
        this.server = server;
        this.pos = pos;
        this.name = name;
        this.tab = tab;
        this.clone = clone;
    }

    public SPacketToolMobSpawner(FriendlyByteBuf buf) {
        this.createSpawner = buf.readBoolean();
        this.server = buf.readBoolean();
        this.pos = buf.readBlockPos();
        this.name = buf.readUtf(Short.MAX_VALUE);
        this.tab = buf.readInt();
        this.clone = buf.readNbt();
    }

    public static SPacketToolMobSpawner decode(FriendlyByteBuf buf) {
        return new SPacketToolMobSpawner(buf);
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return item.getItem() == CustomItems.cloner;
    }

    @Override
    public PermissionNode<Boolean> getPermission() {
        if (this.createSpawner) {
            return CustomNpcsPermissions.SPAWNER_CREATE;
        }
        return CustomNpcsPermissions.SPAWNER_MOB;
    }

    @Override
    protected void handle() {
        if (this.server) {
            this.clone = ServerCloneController.Instance.getCloneData(this.player.createCommandSourceStack(), this.name, this.tab);
        }
        if (this.clone == null || this.clone.isEmpty()) {
            return;
        }
        if (this.createSpawner) {
            SPacketToolMobSpawner.createMobSpawner(this.pos, this.clone, (Player)this.player);
        } else {
            Entity entity = SPacketToolMobSpawner.spawnClone(this.clone, (double)this.pos.getX() + 0.5, this.pos.getY() + 1, (double)this.pos.getZ() + 0.5, this.player.level());
            if (entity == null) {
                this.player.sendSystemMessage((Component)Component.literal((String)"Failed to create an entity out of your clone"));
            }
        }
    }

    public static Entity spawnClone(CompoundTag compound, double x, double y, double z, Level world) {
        ServerCloneController.Instance.cleanTags(compound);
        compound.put("Pos", (Tag)NBTTags.nbtDoubleList(x, y, z));
        Entity entity = (Entity)EntityType.create((CompoundTag)compound, (Level)world).get();
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ais.setStartPos(npc.blockPosition());
        }
        world.addFreshEntity(entity);
        return entity;
    }

    public static void createMobSpawner(BlockPos pos, CompoundTag comp, Player player) {
        ServerCloneController.Instance.cleanTags(comp);
        if (comp.getString("id").equalsIgnoreCase("entityhorse")) {
            player.sendSystemMessage((Component)Component.literal((String)"Currently you cant create horse spawner, its a minecraft bug"));
            return;
        }
        player.level().setBlockAndUpdate(pos, Blocks.SPAWNER.defaultBlockState());
        SpawnerBlockEntity tile = (SpawnerBlockEntity)player.level().getBlockEntity(pos);
        BaseSpawner logic = tile.getSpawner();
        if (!comp.contains("id", 8)) {
            comp.putString("id", "Pig");
        }
        comp.putIntArray("StartPosNew", new int[]{pos.getX(), pos.getY(), pos.getZ()});
        ((BaseSpawnerMixin)logic).callSetNextSpawnData(player.level(), pos, new SpawnData(comp, Optional.empty(), Optional.empty()));
    }

    public static void encode(SPacketToolMobSpawner msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.createSpawner);
        buf.writeBoolean(msg.server);
        buf.writeBlockPos(msg.pos);
        buf.writeUtf(msg.name);
        buf.writeInt(msg.tab);
        buf.writeNbt((Tag)msg.clone);
    }
}

