/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.shared.client.gui.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import noppes.npcs.client.CustomNpcResourceListener;

public class GuiLabel
extends AbstractWidget
implements GuiEventListener {
    public int id;
    private boolean centered = false;
    public boolean enabled = true;
    private boolean labelBgEnabled;
    private int textColor;
    private int backColor;
    private int ulColor;
    private int brColor;
    private int border;

    public GuiLabel(int id, Component label, int color, int x, int y, int width, int height) {
        super(x, y, width, height, label);
        this.id = id;
        this.textColor = color;
        this.width = Minecraft.getInstance().font.width((FormattedText)this.getMessage());
    }

    public GuiLabel(int id, String s, int x, int y) {
        this(id, (Component)Component.translatable((String)s), CustomNpcResourceListener.DefaultTextColor, x, y, 40, 0);
    }

    public GuiLabel(int id, String s, int x, int y, String tooltip) {
        this(id, (Component)Component.translatable((String)s), CustomNpcResourceListener.DefaultTextColor, x, y, 40, 10);
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)tooltip).setStyle(Style.EMPTY.withColor(16762460))));
    }

    public GuiLabel(int id, String s, int x, int y, int color) {
        this(id, (Component)Component.translatable((String)s), color, x, y, 40, 0);
    }

    public GuiLabel(int id, String s, int x, int y, int width, int height) {
        this(id, (Component)Component.translatable((String)s), CustomNpcResourceListener.DefaultTextColor, x, y, width, height);
        this.centered = true;
    }

    public GuiLabel(int id, String s, int x, int y, int color, int width, int height) {
        this(id, (Component)Component.translatable((String)s), color, x, y, width, height);
        this.centered = true;
    }

    public void setColor(int color) {
        this.textColor = color;
    }

    public void setCentered(boolean bo) {
        this.centered = bo;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.enabled) {
            this.drawBox(graphics);
            int i = this.getY() + this.height / 2 + this.border / 2;
            if (this.centered) {
                graphics.drawString(Minecraft.getInstance().font, this.getMessage(), (int)((float)this.getX() + (float)(this.width - Minecraft.getInstance().font.width((FormattedText)this.getMessage())) / 2.0f), this.getY(), this.textColor, false);
            } else {
                graphics.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX(), this.getY(), this.textColor, false);
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    protected void drawBox(GuiGraphics graphics) {
        if (this.labelBgEnabled) {
            int i = this.width + this.border * 2;
            int j = this.height + this.border * 2;
            int k = this.getX() - this.border;
            int l = this.getY() - this.border;
            graphics.fill(k, l, k + i, l + j, this.backColor);
            graphics.hLine(k, k + i, l, this.ulColor);
            graphics.hLine(k, k + i, l + j, this.brColor);
            graphics.hLine(k, l, l + j, this.ulColor);
            graphics.hLine(k + i, l, l + j, this.brColor);
        }
    }
}

