/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.shared.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;

public class GuiMenuTopButton
extends GuiButtonNop {
    public static final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/menutopbutton.png");
    protected int height;
    public boolean active = false;
    public boolean hover = false;
    public boolean rotated = false;

    public GuiMenuTopButton(IGuiInterface gui, int i, int j, int k, String s) {
        super(gui, i, j, k, s);
        this.width = Minecraft.getInstance().font.width((FormattedText)this.getMessage()) + 12;
        this.height = 20;
    }

    public GuiMenuTopButton(IGuiInterface gui, int i, GuiButtonNop parent, String s) {
        this(gui, i, parent.getX() + parent.getWidth(), parent.getY(), s);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int i, int j, float partialTicks) {
        if (!this.visible) {
            return;
        }
        PoseStack matrixStack = graphics.pose();
        Minecraft mc = Minecraft.getInstance();
        matrixStack.pushPose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        int height = this.height - (this.active ? 0 : 2);
        boolean bl = this.hover = i >= this.getX() && j >= this.getY() && i < this.getX() + this.getWidth() && j < this.getY() + height;
        int k = this.active ? 0 : (this.hover ? 2 : 1);
        graphics.blit(resource, this.getX(), this.getY(), 0, k * 20, this.getWidth() / 2, height);
        graphics.blit(resource, this.getX() + this.getWidth() / 2, this.getY(), 200 - this.getWidth() / 2, k * 20, this.getWidth() / 2, height);
        Font fontrenderer = mc.font;
        if (this.rotated) {
            matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        }
        if (this.active) {
            graphics.drawCenteredString(fontrenderer, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + (height - 8) / 2, 0xFFFFA0);
        } else if (this.hover) {
            graphics.drawCenteredString(fontrenderer, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + (height - 8) / 2, 0xFFFFA0);
        } else {
            graphics.drawCenteredString(fontrenderer, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + (height - 8) / 2, 0xE0E0E0);
        }
        matrixStack.popPose();
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        return false;
    }

    public boolean mouseReleased(double i, double j, int button) {
        return false;
    }

    public boolean mouseClicked(double i, double j, int button) {
        boolean bo;
        boolean bl = bo = !this.active && this.visible && this.hover;
        if (bo) {
            this.onClick(i, j);
        }
        return bo;
    }

    @Override
    public void onClick(double x, double y) {
        this.gui.buttonEvent(this);
    }
}

