/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.shared.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiMenuTopButton;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;

public class GuiMenuTopIconButton
extends GuiMenuTopButton {
    private static final ResourceLocation resource = ResourceLocation.tryParse((String)"textures/gui/container/creative_inventory/tabs.png");
    protected static ItemRenderer itemRenderer;
    private ItemStack item;

    public GuiMenuTopIconButton(IGuiInterface gui, int i, int x, int y, String s, ItemStack item) {
        super(gui, i, x, y, s);
        this.width = 28;
        this.height = 28;
        this.item = item;
        itemRenderer = Minecraft.getInstance().getItemRenderer();
    }

    public GuiMenuTopIconButton(IGuiInterface gui, int i, GuiButtonNop parent, String s, ItemStack item) {
        super(gui, i, parent, s);
        this.width = 28;
        this.height = 28;
        this.item = item;
        itemRenderer = Minecraft.getInstance().getItemRenderer();
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        if (this.item.isEmpty()) {
            this.item = new ItemStack((ItemLike)Blocks.DIRT);
        }
        this.hover = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.height;
        Minecraft mc = Minecraft.getInstance();
        if (this.hover) {
            this.drawHoveringText(graphics, Arrays.asList(this.getMessage()), mouseX, mouseY, Minecraft.getInstance().font);
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        graphics.pose().pushPose();
        graphics.blit(resource, this.getX(), this.getY() + (this.active ? 2 : 0), 0, this.active ? 32 : 0, 28, 28);
        graphics.pose().translate(0.0f, 0.0f, 100.0f);
        graphics.renderItem(this.item, this.getX() + 6, this.getY() + 10);
        graphics.renderItemDecorations(mc.font, this.item, this.getX() + 6, this.getY() + 10);
        graphics.pose().popPose();
    }

    protected void drawHoveringText(GuiGraphics graphics, List<Component> list, int x, int y, Font font) {
        if (list.isEmpty()) {
            return;
        }
        RenderSystem.disableDepthTest();
        int k = 0;
        for (Component o : list) {
            int l = font.width((FormattedText)o);
            if (l <= k) continue;
            k = l;
        }
        int j2 = x;
        int k2 = y;
        int i1 = 8;
        if (list.size() > 1) {
            i1 += 2 + (list.size() - 1) * 10;
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 300.0f);
        int j1 = -267386864;
        graphics.fillGradient(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
        graphics.fillGradient(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
        graphics.fillGradient(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
        graphics.fillGradient(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
        graphics.fillGradient(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
        int k1 = 0x505000FF;
        int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
        graphics.fillGradient(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
        graphics.fillGradient(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
        graphics.fillGradient(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
        graphics.fillGradient(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Component s1 = list.get(i2);
            graphics.drawString(font, s1, j2, k2, -1);
            if (i2 == 0) {
                k2 += 2;
            }
            k2 += 10;
        }
        graphics.pose().popPose();
        RenderSystem.enableDepthTest();
    }
}

