/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.shared.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import noppes.npcs.shared.client.gui.listeners.ISliderListener;

public class GuiSliderNop
extends AbstractWidget {
    ResourceLocation WIDGETS_LOCATION = new ResourceLocation("customnpcs", "textures/gui/widgets.png");
    private ISliderListener listener;
    public int id;
    public float sliderValue = 1.0f;
    public float startValue = 1.0f;
    public static final int UNSET_FG_COLOR = -1;
    protected int packedFGColor = -1;

    public int getFGColor() {
        if (this.packedFGColor != -1) {
            return this.packedFGColor;
        }
        return this.active ? 0xFFFFFF : 0xA0A0A0;
    }

    public void setFGColor(int color) {
        this.packedFGColor = color;
    }

    public void clearFGColor() {
        this.packedFGColor = -1;
    }

    public GuiSliderNop(Screen parent, int id, int xPos, int yPos, String displayString, float sliderValue) {
        super(xPos, yPos, 150, 20, (Component)Component.translatable((String)displayString));
        this.id = id;
        this.sliderValue = sliderValue;
        this.startValue = sliderValue;
        this.listener = (ISliderListener)parent;
    }

    public GuiSliderNop(Screen parent, int id, int xPos, int yPos, float sliderValue) {
        this(parent, id, xPos, yPos, "", sliderValue);
        this.listener.mouseDragged(this);
    }

    public GuiSliderNop(Screen parent, int id, int xPos, int yPos, int width, int height, float sliderValue) {
        this(parent, id, xPos, yPos, "", sliderValue);
        this.width = width;
        this.height = height;
        this.listener.mouseDragged(this);
    }

    public void setString(String str) {
        this.setMessage((Component)Component.translatable((String)str));
    }

    private void setSliderValue(float value) {
        if ((value = Mth.clamp((float)value, (float)0.0f, (float)1.0f)) == this.sliderValue) {
            return;
        }
        this.sliderValue = value;
        this.listener.mouseDragged(this);
    }

    protected void renderWidget(GuiGraphics p_93676_, int p_93677_, int p_93678_, float p_93679_) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.WIDGETS_LOCATION);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int i = 0;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        p_93676_.blit(this.WIDGETS_LOCATION, this.getX(), this.getY(), 0, 46 + i * 20, this.width / 2, this.height);
        p_93676_.blit(this.WIDGETS_LOCATION, this.getX() + this.width / 2, this.getY(), 200 - this.width / 2, 46 + i * 20, this.width / 2, this.height);
        this.renderBg(p_93676_, minecraft, p_93677_, p_93678_);
        int j = this.getFGColor();
        p_93676_.drawCenteredString(font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public void onClick(double x, double y) {
        if (!this.visible || !this.active) {
            return;
        }
        this.setSliderValue((float)(x - (double)(this.getX() + 4)) / (float)(this.width - 8));
        super.onClick(x, y);
    }

    protected void onDrag(double x, double y, double p_onDrag_5_, double p_onDrag_7_) {
        this.setSliderValue((float)(x - (double)(this.getX() + 4)) / (float)(this.width - 8));
        super.onDrag(x, y, p_onDrag_5_, p_onDrag_7_);
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public void onRelease(double x, double y) {
        if (this.sliderValue == this.startValue) {
            return;
        }
        super.playDownSound(Minecraft.getInstance().getSoundManager());
        this.listener.mouseReleased(this);
        this.startValue = this.sliderValue;
    }

    public void renderBg(GuiGraphics graphics, Minecraft mc, int p_146119_2_, int p_146119_3_) {
        if (!this.visible) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.WIDGETS_LOCATION);
        int lvt_4_1_ = (this.isHovered ? 2 : 1) * 20;
        graphics.blit(this.WIDGETS_LOCATION, this.getX() + (int)((double)this.sliderValue * (double)(this.width - 8)), this.getY(), 0, 46 + lvt_4_1_, 4, 20);
        graphics.blit(this.WIDGETS_LOCATION, this.getX() + (int)((double)this.sliderValue * (double)(this.width - 8)) + 4, this.getY(), 196, 46 + lvt_4_1_, 4, 20);
    }
}

