/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface IBossMusicProvider {
    @NotNull
    public SoundEvent getBossMusic();

    default public boolean shouldPlayBossMusic(Player listener) {
        Entity e = (Entity)this;
        return e.isAlive() && listener.distanceToSqr(e) <= this.getMusicRangeSqr();
    }

    default public SoundSource soundSource() {
        return SoundSource.RECORDS;
    }

    default public double getMusicRangeSqr() {
        return 4096.0;
    }

    default public int getFadeIn() {
        return 40;
    }

    default public int getFadeOut() {
        return 40;
    }
}

