/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.item;

import dev.xylonity.knightlib.api.IHomunculusInteractable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class HomunculusItem
extends Item {
    public HomunculusItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Block block = level.getBlockState(pos).getBlock();
        if (block instanceof IHomunculusInteractable) {
            IHomunculusInteractable actor = (IHomunculusInteractable)block;
            if (!actor.canInteract(context)) {
                return InteractionResult.FAIL;
            }
            actor.onPreInteraction(context);
            if (!level.isClientSide) {
                stack.shrink(actor.shrinkItemAmount());
            }
            if (!actor.getInteractionSounds().isEmpty()) {
                for (SoundEvent sound : actor.getInteractionSounds()) {
                    level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            actor.onPostInteraction(context);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.item.knightlib.homunculus"));
    }
}

