/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public abstract class AbstractRibbonTrailParticle
extends Particle {
    protected static final int MAX_TRAIL_POINTS = 64;
    protected final Vec3[] positionBuffer = new Vec3[64];
    protected int bufferIdx = -1;
    public float r;
    public float g;
    public float b;
    protected float ribbonAlpha = 1.0f;

    public AbstractRibbonTrailParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, float r, float g, float b) {
        super(level, x, y, z);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.r = r;
        this.g = g;
        this.b = b;
        Arrays.fill(this.positionBuffer, new Vec3(x, y, z));
    }

    public void tick() {
        this.savePosInBuffer();
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.99;
        this.yd *= 0.99;
        this.zd *= 0.99;
        this.yd -= (double)this.gravity;
        if (++this.age >= this.lifetime) {
            this.remove();
        }
    }

    protected void savePosInBuffer() {
        Vec3 current = new Vec3(this.x, this.y, this.z);
        if (this.bufferIdx == -1) {
            Arrays.fill(this.positionBuffer, current);
        }
        if (++this.bufferIdx >= 64) {
            this.bufferIdx = 0;
        }
        this.positionBuffer[this.bufferIdx] = current;
    }

    public void render(@NotNull VertexConsumer ignored, @NotNull Camera camera, float partialTicks) {
        if (this.bufferIdx < 0) {
            return;
        }
        MultiBufferSource.BufferSource buff = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = buff.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getRibbonSprite()));
        PoseStack mPose = new PoseStack();
        mPose.pushPose();
        mPose.translate(-camera.getPosition().x, -camera.getPosition().y, -camera.getPosition().z);
        Vec3 from = new Vec3(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x), Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y), Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z));
        float yaw = (float)(-Math.PI) / 180 * camera.getYRot();
        Vec3 topOffset = new Vec3(0.0, (double)(this.getRibbonHeight() / 2.0f), 0.0).yRot(yaw);
        Vec3 botOffset = new Vec3(0.0, (double)(-this.getRibbonHeight() / 2.0f), 0.0).yRot(yaw);
        int segments = this.totalSegments();
        for (int i = 0; i < segments; ++i) {
            Vec3 samplex = this.sampleTrailPoint(i * this.segmentInterval(), partialTicks);
            float u1 = (float)i / (float)segments;
            float u2 = (float)(i + 1) / (float)segments;
            PoseStack.Pose pose = mPose.last();
            Matrix4f mat = pose.pose();
            Matrix3f norm = pose.normal();
            vertexConsumer.addVertex(mat, (float)from.x + (float)botOffset.x, (float)from.y + (float)botOffset.y, (float)from.z + (float)botOffset.z).setColor(this.r, this.g, this.b, this.ribbonAlpha).setUv(u1, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(this.getLightColor(partialTicks)).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(mat, (float)samplex.x + (float)botOffset.x, (float)samplex.y + (float)botOffset.y, (float)samplex.z + (float)botOffset.z).setColor(this.r, this.g, this.b, this.ribbonAlpha).setUv(u2, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(this.getLightColor(partialTicks)).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(mat, (float)samplex.x + (float)topOffset.x, (float)samplex.y + (float)topOffset.y, (float)samplex.z + (float)topOffset.z).setColor(this.r, this.g, this.b, this.ribbonAlpha).setUv(u2, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(this.getLightColor(partialTicks)).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(mat, (float)from.x + (float)topOffset.x, (float)from.y + (float)topOffset.y, (float)from.z + (float)topOffset.z).setColor(this.r, this.g, this.b, this.ribbonAlpha).setUv(u1, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(this.getLightColor(partialTicks)).setNormal(pose, 0.0f, 1.0f, 0.0f);
            from = samplex;
        }
        mPose.popPose();
        buff.endBatch();
    }

    protected Vec3 sampleTrailPoint(int idx, float tick) {
        Vec3 position = this.positionBuffer[this.bufferIdx - idx - 1 & 0x3F];
        Vec3 subtract = this.positionBuffer[this.bufferIdx - idx & 0x3F].subtract(position);
        return position.add(subtract.scale((double)tick));
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    protected int totalSegments() {
        return 20;
    }

    protected int segmentInterval() {
        return 1;
    }

    protected abstract float getRibbonHeight();

    protected abstract ResourceLocation getRibbonSprite();
}

